/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jose;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.DateUtils;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class JoseUtils {
    public static final String JOSE_PART_SEP = ".";
    private static final Pattern JOSE_PART_SEP_PATTERN = Pattern.compile("\\.");
    public static final String ALG_NONE = "none";

    public static String[] parseParts(String token) {
        AssertUtils.assertNotNull(token);
        String[] parts = JOSE_PART_SEP_PATTERN.split(token);
        if (parts.length == 2) {
            String[] stringArray;
            if (token.endsWith(JOSE_PART_SEP)) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = parts[0];
                stringArray2[1] = parts[1];
                stringArray = stringArray2;
                stringArray2[2] = null;
            } else {
                stringArray = null;
            }
            return stringArray;
        }
        if (parts.length != 3) {
            return null;
        }
        return parts;
    }

    public static Long toNumericDate(Date value) {
        if (value == null) {
            return null;
        }
        return DateUtils.clearMs(value).getTime() / 1000L;
    }

    public static Date toDate(Long numericDate) {
        if (numericDate == null) {
            return null;
        }
        return new Date(numericDate * 1000L);
    }

    public static Long toLongValue(Object value) {
        if (value == null || value.getClass() == Long.class) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new IllegalArgumentException("value must be instance of Number.");
    }

    public static Double toDoubleValue(Object value) {
        if (value == null || value.getClass() == Double.class) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new IllegalArgumentException("value must be instance of Number.");
    }

    public static void convertToLong(Map<String, Object> map, Set<String> props) {
        for (String prop : props) {
            if (!map.containsKey(prop)) continue;
            map.put(prop, JoseUtils.toLongValue(map.get(prop)));
        }
    }
}

