/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jdbc;

import com.appslandia.common.utils.AssertUtils;
import java.util.stream.IntStream;

public class SqlLikeEscaper {
    final char escapeSignChar;
    final char[] charsToEscape;
    private static volatile SqlLikeEscaper __default;
    private static volatile char __escapeSignChar;
    private static volatile char[] __charsToEscape;
    private static final Object MUTEX;

    public SqlLikeEscaper(char escapeSignChar, char[] charsToEscape) {
        AssertUtils.assertNotNull(charsToEscape);
        this.escapeSignChar = escapeSignChar;
        this.charsToEscape = (char[])charsToEscape.clone();
    }

    public String escape(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(value.length() + value.length() / 5);
        sb.append(value);
        int i = -1;
        block0: while (++i != sb.length()) {
            for (char c : this.charsToEscape) {
                if (c != sb.charAt(i)) continue;
                sb.insert(i, this.escapeSignChar);
                ++i;
                continue block0;
            }
        }
        return sb.toString();
    }

    public boolean hasEscapeSignChar(String value) {
        if (value == null) {
            return false;
        }
        return IntStream.range(0, value.length() - 1).anyMatch(index -> value.charAt(index) == SqlLikeEscaper.getEscapeSignChar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlLikeEscaper getDefault() {
        SqlLikeEscaper obj = __default;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __default;
                if (obj == null) {
                    __default = obj = new SqlLikeEscaper(SqlLikeEscaper.getEscapeSignChar(), SqlLikeEscaper.getCharsToEscape());
                }
            }
        }
        return obj;
    }

    public static void setDefault(SqlLikeEscaper obj) {
        AssertUtils.assertNull(__default);
        __default = obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char getEscapeSignChar() {
        int chr = __escapeSignChar;
        if (chr == 0) {
            Object object = MUTEX;
            synchronized (object) {
                chr = __escapeSignChar;
                if (chr == 0) {
                    chr = 92;
                    __escapeSignChar = (char)92;
                }
            }
        }
        return (char)chr;
    }

    public static void setEscapeSignChar(char escapeSignChar) {
        AssertUtils.assertNull(Character.valueOf(__escapeSignChar));
        __escapeSignChar = escapeSignChar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] getCharsToEscape() {
        char[] obj = __charsToEscape;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __charsToEscape;
                if (__charsToEscape == null) {
                    obj = new char[]{'%', '_'};
                    __charsToEscape = obj;
                }
            }
        }
        return (char[])obj.clone();
    }

    public static void setCharsToEscape(char[] charsToEscape) {
        AssertUtils.assertNull(__charsToEscape);
        __charsToEscape = charsToEscape;
    }

    static {
        MUTEX = new Object();
    }
}

