/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.DateFormatter;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.utils.StringUtils;
import java.sql.Timestamp;
import java.util.Date;

public class SqlTimestampFormatter
extends DateFormatter {
    public static final String ERROR_MSG_KEY = SqlTimestampFormatter.class.getName() + ".message";

    public SqlTimestampFormatter() {
        super(false);
    }

    public SqlTimestampFormatter(boolean localized) {
        super(localized);
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return Timestamp.class;
    }

    @Override
    protected String getLocalizedPattern(FormatProvider formatProvider) {
        return formatProvider.getLanguage().getPatternDateTime();
    }

    @Override
    protected String getIsoPattern() {
        return "yyyy-MM-dd'T'HH:mm:ss.SSS";
    }

    @Override
    public Timestamp parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        Date d = this.doParse(str, formatProvider);
        return d != null ? new Timestamp(d.getTime()) : null;
    }
}

