/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.DateFormatter;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.utils.StringUtils;
import java.sql.Time;
import java.util.Date;

public class SqlTimeMIFormatter
extends DateFormatter {
    public static final String ERROR_MSG_KEY = SqlTimeMIFormatter.class.getName() + ".message";

    public SqlTimeMIFormatter() {
        super(false);
    }

    public SqlTimeMIFormatter(boolean localized) {
        super(localized);
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return Time.class;
    }

    @Override
    protected String getLocalizedPattern(FormatProvider formatProvider) {
        return formatProvider.getLanguage().getPatternTimeMI();
    }

    @Override
    protected String getIsoPattern() {
        return "HH:mm";
    }

    @Override
    public Time parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        Date d = this.doParse(str, formatProvider);
        return d != null ? new Time(d.getTime()) : null;
    }
}

