/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.NumberFormatter;
import com.appslandia.common.utils.StringUtils;
import java.text.NumberFormat;

public class ShortFormatter
extends NumberFormatter {
    public static final String ERROR_MSG_KEY = ShortFormatter.class.getName() + ".message";

    public ShortFormatter() {
        super(false);
    }

    public ShortFormatter(boolean localized) {
        super(localized);
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return Short.class;
    }

    @Override
    protected NumberFormat getLocalizedFormat(FormatProvider formatProvider) {
        return formatProvider.getIntegerFormat();
    }

    @Override
    public Short parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException numberFormatException) {
            Number number = this.parseNumber(str, formatProvider);
            long value = number.longValue();
            if (value < -32768L || value > 32767L) {
                throw this.parsedOvfException(str);
            }
            return number.shortValue();
        }
    }
}

