/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterException;
import java.text.NumberFormat;
import java.text.ParsePosition;

public abstract class NumberFormatter
implements Formatter {
    final boolean localized;

    public NumberFormatter(boolean localized) {
        this.localized = localized;
    }

    protected abstract NumberFormat getLocalizedFormat(FormatProvider var1);

    @Override
    public String format(Object obj, FormatProvider formatProvider) {
        if (obj == null) {
            return null;
        }
        if (this.localized) {
            return this.getLocalizedFormat(formatProvider).format(this.getArgType().cast(obj));
        }
        return this.getArgType().cast(obj).toString();
    }

    protected Number parseNumber(String str, FormatProvider formatProvider) throws FormatterException {
        ParsePosition pos = new ParsePosition(0);
        Number parsedValue = this.getLocalizedFormat(formatProvider).parse(str, pos);
        if (pos.getErrorIndex() < 0 && pos.getIndex() == str.length() && parsedValue != null) {
            return parsedValue;
        }
        throw new FormatterException("An error occurred while parsing number (str=" + str + ", type=" + this.getArgType() + ")", this.getErrorMsgKey());
    }

    protected FormatterException parsedOvfException(String str) {
        return new FormatterException("An overflow occurred while parsing number (str=" + str + ", type=" + this.getArgType() + ")", this.getErrorMsgKey());
    }
}

