/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.utils.StringUtils;
import java.util.Locale;

public class LowerUpperFormatter
implements Formatter {
    public static final String ERROR_MSG_KEY = LowerUpperFormatter.class.getName() + ".message";
    final Locale locale;
    final boolean lowerCase;

    public LowerUpperFormatter(boolean lowerCase, Locale locale) {
        this.lowerCase = lowerCase;
        this.locale = locale;
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return String.class;
    }

    @Override
    public String format(Object obj, FormatProvider formatProvider) {
        return (String)obj;
    }

    @Override
    public String parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return str;
        }
        if (this.locale != null) {
            return this.lowerCase ? str.toLowerCase(this.locale) : str.toUpperCase(this.locale);
        }
        return this.lowerCase ? str.toLowerCase(formatProvider.getLanguage().getLocale()) : str.toUpperCase(formatProvider.getLanguage().getLocale());
    }
}

