/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.utils.StringUtils;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class Jdk8DateFormatter<T extends TemporalAccessor>
implements Formatter {
    private static final ConcurrentMap<String, DateTimeFormatter> FORMATTER_CACHE = new ConcurrentHashMap<String, DateTimeFormatter>();
    final boolean localized;

    public Jdk8DateFormatter(boolean localized) {
        this.localized = localized;
    }

    protected abstract String getLocalizedPattern(FormatProvider var1);

    protected abstract String getIsoPattern();

    protected abstract T parse(String var1, DateTimeFormatter var2) throws DateTimeParseException;

    @Override
    public String format(Object obj, FormatProvider formatProvider) {
        if (obj == null) {
            return null;
        }
        if (this.localized) {
            return Jdk8DateFormatter.getFormatter(this.getLocalizedPattern(formatProvider)).format((TemporalAccessor)this.getArgType().cast(obj));
        }
        return Jdk8DateFormatter.getFormatter(this.getIsoPattern()).format((TemporalAccessor)this.getArgType().cast(obj));
    }

    public T parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        try {
            return this.parse(str, Jdk8DateFormatter.getFormatter(this.getIsoPattern()));
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return this.parse(str, Jdk8DateFormatter.getFormatter(this.getLocalizedPattern(formatProvider)));
            }
            catch (DateTimeParseException dateTimeParseException2) {
                throw new FormatterException("An error occurred while parsing temporal (str=" + str + ", type=" + this.getArgType() + ")", this.getErrorMsgKey());
            }
        }
    }

    protected static DateTimeFormatter getFormatter(String pattern) {
        return FORMATTER_CACHE.computeIfAbsent(pattern, p -> DateTimeFormatter.ofPattern(p));
    }
}

