/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Provider;
import com.appslandia.common.formatters.BigDecimalFormatter;
import com.appslandia.common.formatters.BooleanFormatter;
import com.appslandia.common.formatters.ByteFormatter;
import com.appslandia.common.formatters.DoubleFormatter;
import com.appslandia.common.formatters.FloatFormatter;
import com.appslandia.common.formatters.Fmt;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.IntegerFormatter;
import com.appslandia.common.formatters.LongFormatter;
import com.appslandia.common.formatters.LowerUpperFormatter;
import com.appslandia.common.formatters.ShortFormatter;
import com.appslandia.common.formatters.SingleLineStringFormatter;
import com.appslandia.common.formatters.SqlDateFormatter;
import com.appslandia.common.formatters.SqlTimeFormatter;
import com.appslandia.common.formatters.SqlTimeMIFormatter;
import com.appslandia.common.formatters.SqlTimestampFormatter;
import com.appslandia.common.formatters.SqlTimestampMIFormatter;
import com.appslandia.common.formatters.StringFormatter;
import com.appslandia.common.formatters.TrimToEmptyFormatter;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.TypeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FormatterProvider
extends InitializeObject {
    private Map<String, Formatter> formatterMap = new HashMap<String, Formatter>();
    private static volatile FormatterProvider __default;
    private static final Object MUTEX;
    private static Provider<FormatterProvider> __provider;

    @Override
    protected void init() throws Exception {
        this.addDefault("Byte", new ByteFormatter());
        this.addDefault("Short", new ShortFormatter());
        this.addDefault("ShortLZ", new ShortFormatter(true));
        this.addDefault("Integer", new IntegerFormatter());
        this.addDefault("IntegerLZ", new IntegerFormatter(true));
        this.addDefault("Long", new LongFormatter());
        this.addDefault("LongLZ", new LongFormatter(true));
        this.addDefault("Float", new FloatFormatter());
        this.addDefault("FloatLZ", new FloatFormatter(true));
        this.addDefault("Double", new DoubleFormatter());
        this.addDefault("DoubleLZ", new DoubleFormatter(true));
        this.addDefault("BigDecimal", new BigDecimalFormatter());
        this.addDefault("BigDecimalLZ", new BigDecimalFormatter(true));
        this.addDefault("Time", new SqlTimeFormatter());
        this.addDefault("TimeMI", new SqlTimeMIFormatter());
        this.addDefault("Date", new SqlDateFormatter());
        this.addDefault("DateLZ", new SqlDateFormatter(true));
        this.addDefault("Timestamp", new SqlTimestampFormatter());
        this.addDefault("TimestampLZ", new SqlTimestampFormatter(true));
        this.addDefault("TimestampMI", new SqlTimestampMIFormatter());
        this.addDefault("TimestampMILZ", new SqlTimestampMIFormatter(true));
        this.addDefault("Boolean", new BooleanFormatter());
        this.addDefault("String", new StringFormatter());
        this.addDefault("SingleLine", new SingleLineStringFormatter());
        this.addDefault("TrimToEmpty", new TrimToEmptyFormatter());
        this.addDefault("Upper", new LowerUpperFormatter(false, null));
        this.addDefault("Lower", new LowerUpperFormatter(true, null));
        this.addDefault("EnUpper", new LowerUpperFormatter(false, Locale.ENGLISH));
        this.addDefault("EnLower", new LowerUpperFormatter(true, Locale.ENGLISH));
        this.addDefault("InvariantUpper", new LowerUpperFormatter(false, Locale.ROOT));
        this.addDefault("InvariantLower", new LowerUpperFormatter(true, Locale.ROOT));
        this.formatterMap = Collections.unmodifiableMap(this.formatterMap);
    }

    protected void addDefault(String formatterId, Formatter formatter) {
        if (!this.formatterMap.containsKey(formatterId)) {
            this.formatterMap.put(formatterId, formatter);
        }
    }

    public void addFormatter(String formatterId, Formatter formatter) {
        this.assertNotInitialized();
        this.formatterMap.put(formatterId, formatter);
    }

    public Formatter findFormatter(Fmt fmt, Class<?> targetType) {
        this.initialize();
        if (fmt != null) {
            return this.getFormatter(fmt.value());
        }
        return this.formatterMap.get(TypeUtils.wrap(targetType).getSimpleName());
    }

    public Formatter findFormatter(String formatterId, Class<?> targetType) {
        this.initialize();
        if (formatterId != null) {
            return this.getFormatter(formatterId);
        }
        return this.formatterMap.get(TypeUtils.wrap(targetType).getSimpleName());
    }

    public Formatter getFormatter(Class<?> targetType) throws IllegalArgumentException {
        this.initialize();
        Formatter formatter = this.formatterMap.get(TypeUtils.wrap(targetType).getSimpleName());
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter is not found (targetType=" + targetType + ")");
        }
        return formatter;
    }

    public Formatter getFormatter(String formatterId) throws IllegalArgumentException {
        this.initialize();
        Formatter formatter = this.formatterMap.get(formatterId);
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter is not found (formatterId=" + formatterId + ")");
        }
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormatterProvider getDefault() {
        FormatterProvider obj = __default;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __default;
                if (obj == null) {
                    __default = obj = FormatterProvider.initFormatterProvider();
                }
            }
        }
        return obj;
    }

    public static void setDefault(FormatterProvider obj) {
        AssertUtils.assertNull(__default);
        __default = obj;
    }

    public static void setProvider(Provider<FormatterProvider> provider) {
        AssertUtils.assertNull(__default);
        __provider = provider;
    }

    private static FormatterProvider initFormatterProvider() {
        if (__provider != null) {
            return __provider.get();
        }
        return new FormatterProvider();
    }

    static {
        MUTEX = new Object();
    }
}

