/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.NumberFormatter;
import com.appslandia.common.utils.StringUtils;
import java.text.NumberFormat;

public class FloatFormatter
extends NumberFormatter {
    public static final String ERROR_MSG_KEY = FloatFormatter.class.getName() + ".message";

    public FloatFormatter() {
        super(false);
    }

    public FloatFormatter(boolean localized) {
        super(localized);
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return Float.class;
    }

    @Override
    protected NumberFormat getLocalizedFormat(FormatProvider formatProvider) {
        return formatProvider.getNumberFormat();
    }

    @Override
    public Float parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(str));
        }
        catch (NumberFormatException numberFormatException) {
            double posDouble;
            Number number = this.parseNumber(str, formatProvider);
            double doubleValue = number.doubleValue();
            double d = posDouble = doubleValue >= 0.0 ? doubleValue : doubleValue * -1.0;
            if (posDouble != 0.0 && (posDouble < (double)1.4E-45f || posDouble > 3.4028234663852886E38)) {
                throw this.parsedOvfException(str);
            }
            return Float.valueOf(number.floatValue());
        }
    }
}

