/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.NumberFormatter;
import com.appslandia.common.utils.StringUtils;
import java.text.NumberFormat;

public class ByteFormatter
extends NumberFormatter {
    public static final String ERROR_MSG_KEY = ByteFormatter.class.getName() + ".message";

    public ByteFormatter() {
        super(false);
    }

    public ByteFormatter(boolean localized) {
        super(localized);
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return Byte.class;
    }

    @Override
    protected NumberFormat getLocalizedFormat(FormatProvider formatProvider) {
        return formatProvider.getIntegerFormat();
    }

    @Override
    public Byte parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException numberFormatException) {
            Number number = this.parseNumber(str, formatProvider);
            long value = number.longValue();
            if (value < -128L || value > 127L) {
                throw this.parsedOvfException(str);
            }
            return number.byteValue();
        }
    }
}

