/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.easyrecord;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.TextBuilder;
import com.appslandia.common.easyrecord.Field;
import com.appslandia.common.easyrecord.KeyType;
import com.appslandia.common.jdbc.Sql;
import com.appslandia.common.utils.AssertUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Table
extends InitializeObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Field autoKey;
    final List<Field> fields = new ArrayList<Field>();
    private Sql insertSql;
    private Sql updateSql;
    private Sql deleteSql;
    private Sql getSql;
    private Sql existsSql;
    private String getAllSql;

    public Table() {
    }

    public Table(String name) {
        this.setName(name);
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.name, "name is required.");
        AssertUtils.assertTrue(!this.fields.isEmpty(), "fields are required.");
        int keyCount = 0;
        for (Field field : this.fields) {
            AssertUtils.assertNotNull(field.getName(), "field name is required.");
            if (field.getKeyType() == KeyType.NON_KEY) continue;
            ++keyCount;
            field.addConstraint("required", null);
            field.setUpdatable(false);
            if (field.getKeyType() != KeyType.AUTO_KEY) continue;
            AssertUtils.assertNull((Object)this.autoKey, "autoKey duplicated.");
            this.autoKey = field;
        }
        if (keyCount == 0) {
            throw new IllegalArgumentException("No keys found.");
        }
        this.insertSql = new Sql().sql(this.buildInsertSQL());
        this.updateSql = new Sql().sql(this.buildUpdateSQL());
        this.deleteSql = new Sql().sql(this.buildDeleteSQL());
        this.getSql = new Sql().sql(this.buildGetSQL());
        this.existsSql = new Sql().sql(this.buildExistsSQL());
        this.getAllSql = this.buildGetAllSQL();
    }

    protected String buildInsertSQL() {
        TextBuilder sb = new TextBuilder().append("INSERT INTO ").append(this.name);
        sb.append(" ( ");
        boolean isFirst = true;
        for (Field field : this.fields) {
            if (field.isAutoKey()) continue;
            if (isFirst) {
                sb.append(field.getName());
                isFirst = false;
                continue;
            }
            sb.append(", ").append(field.getName());
        }
        sb.append(" )");
        sb.append(" VALUES ( ");
        isFirst = true;
        for (Field field : this.fields) {
            if (field.isAutoKey()) continue;
            if (isFirst) {
                sb.append("@").append(field.getName());
                isFirst = false;
                continue;
            }
            sb.append(", @").append(field.getName());
        }
        sb.append(" )");
        return sb.toString();
    }

    protected String buildUpdateSQL() {
        TextBuilder sb = new TextBuilder().append("UPDATE ").append(this.name);
        sb.append(" SET ");
        boolean isFirst = true;
        for (Field field : this.fields) {
            if (!field.isUpdatable()) continue;
            if (isFirst) {
                sb.append(field.getName()).append("= @").append(field.getName());
                isFirst = false;
                continue;
            }
            sb.append(", ").append(field.getName()).append("= @").append(field.getName());
        }
        sb.append(" WHERE ");
        this.appendWhereKeyConditions(sb);
        return sb.toString();
    }

    protected String buildDeleteSQL() {
        TextBuilder sb = new TextBuilder().append("DELETE FROM ").append(this.name);
        sb.append(" WHERE ");
        this.appendWhereKeyConditions(sb);
        return sb.toString();
    }

    protected String buildExistsSQL() {
        TextBuilder sb = new TextBuilder().append("SELECT COUNT(1) FROM ").append(this.name);
        sb.append(" WHERE ");
        this.appendWhereKeyConditions(sb);
        return sb.toString();
    }

    protected String buildGetSQL() {
        TextBuilder sb = new TextBuilder().append("SELECT * FROM ").append(this.name);
        sb.append(" WHERE ");
        this.appendWhereKeyConditions(sb);
        return sb.toString();
    }

    protected void appendWhereKeyConditions(TextBuilder sqlBuilder) {
        boolean isFirst = true;
        for (Field field : this.fields) {
            if (!field.isKey()) continue;
            if (isFirst) {
                sqlBuilder.append(field.getName()).append("= @").append(field.getName());
                isFirst = false;
                continue;
            }
            sqlBuilder.append(" AND ").append(field.getName()).append("= @").append(field.getName());
        }
    }

    protected String buildGetAllSQL() {
        TextBuilder sb = new TextBuilder().append("SELECT * FROM ").append(this.name);
        return sb.toString();
    }

    public String getName() {
        this.initialize();
        return this.name;
    }

    public Table setName(String name) {
        this.assertNotInitialized();
        this.name = name;
        return this;
    }

    public List<Field> getFields() {
        this.initialize();
        return this.fields;
    }

    public Table addFields(String ... fieldNames) {
        this.assertNotInitialized();
        for (String fieldName : fieldNames) {
            this.fields.add(new Field(fieldName));
        }
        return this;
    }

    public Table addField(Field field) {
        this.assertNotInitialized();
        this.fields.add(field);
        return this;
    }

    public Table addField(String fieldName, int sqlType) {
        this.assertNotInitialized();
        this.fields.add(new Field(fieldName).setSqlType(sqlType));
        return this;
    }

    public Table addAutoKey(String fieldName) {
        this.assertNotInitialized();
        this.fields.add(new Field(fieldName).setKeyType(KeyType.AUTO_KEY));
        return this;
    }

    public Table addKeys(String ... fieldNames) {
        this.assertNotInitialized();
        for (String fieldName : fieldNames) {
            this.fields.add(new Field(fieldName).setKeyType(KeyType.KEY));
        }
        return this;
    }

    public Field getAutoKey() {
        this.initialize();
        return this.autoKey;
    }

    public Sql getInsertSql() {
        this.initialize();
        return this.insertSql;
    }

    public Sql getUpdateSql() {
        this.initialize();
        return this.updateSql;
    }

    public Sql getDeleteSql() {
        this.initialize();
        return this.deleteSql;
    }

    public Sql getGetSql() {
        this.initialize();
        return this.getSql;
    }

    public Sql getExistsSql() {
        this.initialize();
        return this.existsSql;
    }

    public String getGetAllSql() {
        this.initialize();
        return this.getAllSql;
    }
}

