/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.easyrecord;

import com.appslandia.common.easyrecord.KeyType;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class Field
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private int sqlType = 0;
    private KeyType keyType = KeyType.NON_KEY;
    private boolean updatable = true;
    private Map<String, Object> constraints = new LinkedHashMap<String, Object>();

    public Field() {
    }

    public Field(String name) {
        this.setName(name);
    }

    public boolean isAutoKey() {
        return this.keyType == KeyType.AUTO_KEY;
    }

    public boolean isKey() {
        return this.keyType != KeyType.NON_KEY;
    }

    public String getName() {
        return this.name;
    }

    public Field setName(String name) {
        this.name = name;
        return this;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public Field setSqlType(int sqlType) {
        this.sqlType = sqlType;
        return this;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public Field setKeyType(KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public Field setUpdatable(boolean updatable) {
        this.updatable = updatable;
        return this;
    }

    public Map<String, Object> getConstraints() {
        return this.constraints;
    }

    public Object getConstraint(String name) {
        return this.constraints.get(name);
    }

    public Field addConstraint(String name, Object constraintArgs) {
        this.constraints.put(name, constraintArgs);
        return this;
    }
}

