/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.easyrecord;

import com.appslandia.common.easyrecord.Field;
import com.appslandia.common.easyrecord.Record;
import com.appslandia.common.easyrecord.RecordUtils;
import com.appslandia.common.easyrecord.Table;
import com.appslandia.common.jdbc.StatementImpl;
import com.appslandia.common.utils.AssertUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class DbManager
implements AutoCloseable {
    private Connection conn;
    private boolean internalConn;
    private Map<String, StatCache> statCache = new LinkedHashMap<String, StatCache>();
    private boolean closed = false;
    private static DataSource __dataSource;

    public DbManager() throws SQLException {
        this(DbManager.getDataSource());
    }

    public DbManager(Connection conn) {
        this.conn = conn;
        this.internalConn = false;
    }

    public DbManager(DataSource dataSource) throws SQLException {
        this.conn = dataSource.getConnection();
        this.internalConn = true;
    }

    public Connection getConnection() {
        return this.conn;
    }

    protected Object toSqlObject(Object val, int sqlType) {
        if (val == null) {
            return null;
        }
        if (java.util.Date.class.isAssignableFrom(val.getClass())) {
            if (val.getClass() == Date.class || val.getClass() == Time.class || val.getClass() == Timestamp.class) {
                return val;
            }
            if (sqlType == 92) {
                return new Time(((java.util.Date)val).getTime());
            }
            if (sqlType == 93) {
                return new Timestamp(((java.util.Date)val).getTime());
            }
            return new Date(((java.util.Date)val).getTime());
        }
        return val;
    }

    public long insert(Record record, Table table) throws SQLException {
        return this.insert(record, table, false);
    }

    public void insertBatch(Record record, Table table) throws SQLException {
        this.insert(record, table, true);
    }

    protected void setParameter(StatementImpl stat, String parameterName, Object val, int sqlType) throws SQLException {
        if (val != null) {
            stat.setObject(parameterName, val);
        } else if (sqlType > 0) {
            stat.setNull(parameterName, sqlType);
        } else {
            stat.setObject(parameterName, null);
        }
    }

    protected StatCache getStatCache(String tableName) {
        StatCache cache = this.statCache.get(tableName);
        if (cache == null) {
            cache = new StatCache();
            this.statCache.put(tableName, cache);
        }
        return cache;
    }

    protected long insert(Record record, Table table, boolean addBatch) throws SQLException {
        this.assertNotClosed();
        StatCache cache = this.getStatCache(table.getName());
        if (cache.insertStat == null) {
            cache.insertStat = new StatementImpl(this.conn, table.getInsertSql(), table.getAutoKey() != null);
        }
        for (Field field : table.getFields()) {
            if (field.isAutoKey()) continue;
            Object val = record.get(field.getName());
            val = this.toSqlObject(val, field.getSqlType());
            this.setParameter(cache.insertStat, field.getName(), val, field.getSqlType());
        }
        int rowAffected = -1;
        if (!addBatch) {
            rowAffected = cache.insertStat.executeUpdate();
            if (table.getAutoKey() != null) {
                try (ResultSet rs = cache.insertStat.getGeneratedKeys();){
                    if (rs.next()) {
                        Object generatedKey = rs.getObject(1);
                        record.set(table.getAutoKey().getName(), generatedKey);
                        long l = ((Number)generatedKey).longValue();
                        return l;
                    }
                }
            }
        } else {
            cache.insertStat.addBatch();
        }
        return rowAffected;
    }

    public int update(Record record, Table table) throws SQLException {
        return this.update(record, table, false);
    }

    public void updateBatch(Record record, Table table) throws SQLException {
        this.update(record, table, true);
    }

    protected int update(Record record, Table table, boolean addBatch) throws SQLException {
        this.assertNotClosed();
        StatCache cache = this.getStatCache(table.getName());
        if (cache.updateStat == null) {
            cache.updateStat = new StatementImpl(this.conn, table.getUpdateSql());
        }
        for (Field field : table.getFields()) {
            if (!field.isKey() && !field.isUpdatable()) continue;
            Object val = record.get(field.getName());
            val = this.toSqlObject(val, field.getSqlType());
            this.setParameter(cache.updateStat, field.getName(), val, field.getSqlType());
        }
        int rowAffected = -1;
        if (!addBatch) {
            rowAffected = cache.updateStat.executeUpdate();
        } else {
            cache.updateStat.addBatch();
        }
        return rowAffected;
    }

    public int delete(Record key, Table table) throws SQLException {
        return this.delete(key, table, false);
    }

    public void deleteBatch(Record key, Table table) throws SQLException {
        this.delete(key, table, true);
    }

    protected int delete(Record key, Table table, boolean addBatch) throws SQLException {
        this.assertNotClosed();
        StatCache cache = this.getStatCache(table.getName());
        if (cache.deleteStat == null) {
            cache.deleteStat = new StatementImpl(this.conn, table.getDeleteSql());
        }
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            Object val = key.get(field.getName());
            val = this.toSqlObject(val, field.getSqlType());
            this.setParameter(cache.deleteStat, field.getName(), val, field.getSqlType());
        }
        int rowAffected = -1;
        if (!addBatch) {
            rowAffected = cache.deleteStat.executeUpdate();
        } else {
            cache.deleteStat.addBatch();
        }
        return rowAffected;
    }

    public Record getRecord(Record key, Table table) throws SQLException {
        this.assertNotClosed();
        StatCache cache = this.getStatCache(table.getName());
        if (cache.getStat == null) {
            cache.getStat = new StatementImpl(this.conn, table.getGetSql());
        }
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            Object val = key.get(field.getName());
            val = this.toSqlObject(val, field.getSqlType());
            this.setParameter(cache.getStat, field.getName(), val, field.getSqlType());
        }
        return RecordUtils.executeSingle(cache.getStat);
    }

    public boolean exists(Record key, Table table) throws SQLException {
        this.assertNotClosed();
        StatCache cache = this.getStatCache(table.getName());
        if (cache.existsStat == null) {
            cache.existsStat = new StatementImpl(this.conn, table.getExistsSql());
        }
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            Object val = key.get(field.getName());
            val = this.toSqlObject(val, field.getSqlType());
            this.setParameter(cache.existsStat, field.getName(), val, field.getSqlType());
        }
        long count = cache.existsStat.executeCountLong();
        return count == 1L;
    }

    /*
     * Exception decompiling
     */
    public List<Record> getAll(Table table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void executeBatch() throws SQLException {
        this.assertNotClosed();
        AssertUtils.assertTrue(!this.conn.getAutoCommit());
        for (StatCache cache : this.statCache.values()) {
            if (cache.insertStat != null) {
                cache.insertStat.executeBatch();
            }
            if (cache.updateStat != null) {
                cache.updateStat.executeBatch();
            }
            if (cache.deleteStat == null) continue;
            cache.deleteStat.executeBatch();
        }
    }

    public void beginTransaction() throws SQLException {
        this.assertNotClosed();
        this.conn.setAutoCommit(false);
    }

    public void commit() throws SQLException {
        this.assertNotClosed();
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.assertNotClosed();
        this.conn.rollback();
    }

    protected void assertNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException(this + " closed.");
        }
    }

    private void closeStatements() throws SQLException {
        ArrayList<StatCache> caches = new ArrayList<StatCache>(this.statCache.values());
        Collections.reverse(caches);
        for (StatCache cache : caches) {
            if (cache.insertStat != null) {
                cache.insertStat.close();
            }
            if (cache.updateStat != null) {
                cache.updateStat.close();
            }
            if (cache.deleteStat != null) {
                cache.deleteStat.close();
            }
            if (cache.getStat != null) {
                cache.getStat.close();
            }
            if (cache.existsStat == null) continue;
            cache.existsStat.close();
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closeStatements();
            if (this.internalConn) {
                this.conn.close();
            }
            this.closed = true;
        }
    }

    public static DataSource getDataSource() {
        return AssertUtils.assertNotNull(__dataSource);
    }

    public static void setDataSource(DataSource dataSource) {
        AssertUtils.assertNull(dataSource);
        __dataSource = dataSource;
    }

    static class StatCache {
        StatementImpl insertStat;
        StatementImpl updateStat;
        StatementImpl deleteStat;
        StatementImpl getStat;
        StatementImpl existsStat;

        StatCache() {
        }
    }
}

