/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.BaseEncoder;
import com.appslandia.common.base.DestroyException;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.crypto.TextBasedCrypto;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharsetUtils;
import com.appslandia.common.utils.ValueUtils;
import java.nio.charset.Charset;

public class TextEncryptor
extends TextBasedCrypto {
    private Encryptor encryptor;

    public TextEncryptor() {
    }

    public TextEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.encryptor, "encryptor is required.");
        this.textCharset = ValueUtils.valueOrAlt(this.textCharset, CharsetUtils.UTF_8);
        this.baseEncoder = ValueUtils.valueOrAlt(this.baseEncoder, BaseEncoder.BASE64);
    }

    public String encrypt(String message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        return this.baseEncoder.encode(this.encryptor.encrypt(message.getBytes(this.textCharset)));
    }

    public String decrypt(String message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        return new String(this.encryptor.decrypt(this.baseEncoder.decode(message)), this.textCharset);
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.encryptor != null) {
            this.encryptor.destroy();
        }
    }

    public TextEncryptor setEncryptor(Encryptor encryptor) {
        this.assertNotInitialized();
        this.encryptor = encryptor;
        return this;
    }

    @Override
    public TextEncryptor setTextCharset(Charset charset) {
        super.setTextCharset(charset);
        return this;
    }

    @Override
    public TextEncryptor setTextCharset(String textCharset) {
        super.setTextCharset(textCharset);
        return this;
    }

    @Override
    public TextEncryptor setBaseEncoder(BaseEncoder baseEncoder) {
        super.setBaseEncoder(baseEncoder);
        return this;
    }

    public TextEncryptor copy() {
        TextEncryptor impl = new TextEncryptor();
        impl.setTextCharset(this.textCharset).setBaseEncoder(this.baseEncoder);
        if (this.encryptor != null) {
            impl.encryptor = this.encryptor.copy();
        }
        return impl;
    }
}

