/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.MathUtils;

public class SignerEncryptor
extends InitializeObject
implements Encryptor {
    private Encryptor encryptor;
    private Digester signer;

    public SignerEncryptor() {
    }

    public SignerEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public SignerEncryptor(Encryptor encryptor, Digester signer) {
        this.encryptor = encryptor;
        this.signer = signer;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.encryptor, "encryptor is required.");
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.encryptor != null) {
            this.encryptor.destroy();
        }
        if (this.signer != null) {
            this.signer.destroy();
        }
    }

    @Override
    public byte[] encrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        if (this.signer == null) {
            return this.encryptor.encrypt(message);
        }
        byte[] encMsg = this.encryptor.encrypt(message);
        byte[] signature = this.signer.digest(encMsg);
        if (this.signer.getDigestSize() > 0) {
            return ArrayUtils.append(signature, encMsg);
        }
        byte[] sigLen = MathUtils.toByteArray(signature.length);
        return ArrayUtils.append(sigLen, signature, encMsg);
    }

    @Override
    public byte[] decrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        if (this.signer == null) {
            return this.encryptor.decrypt(message);
        }
        byte[] signature = null;
        byte[] encMsg = null;
        int sigLen = this.signer.getDigestSize();
        if (sigLen > 0) {
            signature = new byte[sigLen];
            AssertUtils.assertTrue(message.length > sigLen, "message is invalid.");
            encMsg = new byte[message.length - sigLen];
            ArrayUtils.copy(message, signature, encMsg);
        } else {
            byte[] len = new byte[4];
            AssertUtils.assertTrue(message.length > 4, "message is invalid.");
            ArrayUtils.copy(message, len);
            sigLen = MathUtils.toInt(len);
            AssertUtils.assertTrue(message.length > 4 + sigLen, "message is invalid.");
            signature = new byte[sigLen];
            encMsg = new byte[message.length - sigLen - 4];
            System.arraycopy(message, 4, signature, 0, sigLen);
            System.arraycopy(message, 4 + sigLen, encMsg, 0, encMsg.length);
        }
        if (!this.signer.verify(encMsg, signature)) {
            throw new CryptoException("message was tampered.");
        }
        return this.encryptor.decrypt(encMsg);
    }

    public SignerEncryptor setEncryptor(Encryptor encryptor) {
        this.assertNotInitialized();
        this.encryptor = encryptor;
        return this;
    }

    public SignerEncryptor setSigner(Digester signer) {
        this.assertNotInitialized();
        this.signer = signer;
        return this;
    }

    @Override
    public SignerEncryptor copy() {
        SignerEncryptor impl = new SignerEncryptor();
        if (this.encryptor != null) {
            impl.encryptor = this.encryptor.copy();
        }
        if (this.signer != null) {
            impl.signer = this.signer.copy();
        }
        return impl;
    }
}

