/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.RoundRobinPool;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ValueUtils;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public class SecureString
implements Destroyable {
    final Encryptor encryptor = EncryptorFactory.getDefault().newEncryptor();
    final byte[] secured;
    private boolean destroyed = false;

    public SecureString(char[] clearChars) throws CryptoException {
        this.secured = this.encrypt(clearChars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encrypt(char[] clearChars) throws CryptoException {
        byte[] clearBytes = CryptoUtils.toByteArray(clearChars);
        try {
            byte[] byArray = this.encryptor.encrypt(clearBytes);
            return byArray;
        }
        finally {
            CryptoUtils.clear(clearBytes);
        }
    }

    private char[] decrypt() throws CryptoException {
        char[] cArray;
        byte[] clearBytes = null;
        try {
            clearBytes = this.encryptor.decrypt(this.secured);
            cArray = CryptoUtils.toCharArray(clearBytes);
        }
        catch (Throwable throwable) {
            CryptoUtils.clear(clearBytes);
            throw throwable;
        }
        CryptoUtils.clear(clearBytes);
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T access(Accessor<T> accessor) throws CryptoException {
        this.assertNotDestroyed();
        char[] clearChars = null;
        try {
            clearChars = this.decrypt();
            T t = accessor.access(clearChars);
            return t;
        }
        finally {
            CryptoUtils.clear(clearChars);
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            CryptoUtils.clear(this.secured);
            if (this.encryptor != null) {
                this.encryptor.destroy();
            }
            this.destroyed = true;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    protected void assertNotDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("destroyed.");
        }
    }

    public SecureString copy() throws CryptoException {
        this.assertNotDestroyed();
        char[] clearChars = null;
        try {
            clearChars = this.decrypt();
            SecureString secureString = new SecureString(clearChars);
            return secureString;
        }
        finally {
            CryptoUtils.clear(clearChars);
        }
    }

    public static abstract class EncryptorFactory {
        private static volatile EncryptorFactory __default;
        private static final Object MUTEX;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static EncryptorFactory getDefault() {
            EncryptorFactory obj = __default;
            if (obj == null) {
                Object object = MUTEX;
                synchronized (object) {
                    obj = __default;
                    if (obj == null) {
                        __default = obj = EncryptorFactory.initEncryptorFactory();
                    }
                }
            }
            return obj;
        }

        private static EncryptorFactory initEncryptorFactory() {
            return new Impl();
        }

        public abstract Encryptor newEncryptor();

        static {
            MUTEX = new Object();
        }

        static final class Impl
        extends EncryptorFactory {
            Impl() {
            }

            @Override
            public Encryptor newEncryptor() {
                return new EncryptorImpl();
            }

            static final class EncryptorImpl
            extends InitializeObject
            implements Encryptor {
                private SecretKey key;
                private int poolSize;
                private Decryptor[] decryptors;
                private RoundRobinPool<Decryptor> decryptorPool;
                private static final String ALGORITHM = "AES";
                private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
                private static final IvParameterSpec IV = new IvParameterSpec(new byte[]{81, 101, 34, 35, 100, 5, 106, -66, 81, 101, 34, 35, 100, 5, 106, -66});

                EncryptorImpl() {
                }

                @Override
                protected void init() throws Exception {
                    this.key = KeyGenerator.getInstance(ALGORITHM).generateKey();
                    this.poolSize = ValueUtils.valueOrMin(this.poolSize, Runtime.getRuntime().availableProcessors());
                    this.decryptors = new Decryptor[this.poolSize];
                    for (int i = 0; i < this.poolSize; ++i) {
                        this.decryptors[i] = new Decryptor();
                    }
                    this.decryptorPool = new RoundRobinPool<Decryptor>(this.decryptors);
                }

                @Override
                public void destroy() throws DestroyException {
                    CryptoUtils.destroyQuietly(this.key);
                }

                @Override
                public byte[] encrypt(byte[] message) throws CryptoException {
                    this.initialize();
                    AssertUtils.assertNotNull(message, "message is required.");
                    try {
                        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
                        cipher.init(1, (Key)this.key, IV);
                        return cipher.doFinal(message);
                    }
                    catch (GeneralSecurityException ex) {
                        throw new CryptoException(ex);
                    }
                }

                @Override
                public byte[] decrypt(byte[] message) throws CryptoException {
                    this.initialize();
                    AssertUtils.assertNotNull(message, "message is required.");
                    return this.decryptorPool.next().decrypt(message);
                }

                public EncryptorImpl setPoolSize(int poolSize) {
                    this.assertNotInitialized();
                    this.poolSize = poolSize;
                    return this;
                }

                @Override
                public EncryptorImpl copy() {
                    throw new UnsupportedOperationException();
                }

                final class Decryptor {
                    private Cipher cipher;
                    final Object mutex = new Object();

                    public Decryptor() throws CryptoException {
                        try {
                            this.cipher = Cipher.getInstance(EncryptorImpl.TRANSFORMATION);
                            this.cipher.init(2, (Key)EncryptorImpl.this.key, IV);
                        }
                        catch (GeneralSecurityException ex) {
                            throw new CryptoException(ex);
                        }
                    }

                    public byte[] decrypt(byte[] message) throws CryptoException {
                        Object object = this.mutex;
                        synchronized (object) {
                            try {
                                return this.cipher.doFinal(message);
                            }
                            catch (GeneralSecurityException ex) {
                                throw new CryptoException(ex);
                            }
                        }
                    }
                }
            }
        }
    }

    public static interface Accessor<T> {
        public T access(char[] var1) throws CryptoException;
    }
}

