/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.PropertyConfig;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.crypto.PbeEncryptor;
import com.appslandia.common.crypto.TextEncryptor;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class SecureConfig
extends PropertyConfig {
    private static final long serialVersionUID = 1L;
    final TextEncryptor textEncryptor;
    private static final String ENC_BEGIN = "ENC(";
    private static final String ENC_END = ")";

    public SecureConfig(char[] password) {
        AssertUtils.assertNotNull(password);
        this.textEncryptor = new TextEncryptor(new PbeEncryptor().setTransformation("AES/CBC/PKCS5Padding").setKeySize(32).setPassword(password));
    }

    public SecureConfig(Encryptor encryptor) {
        AssertUtils.assertNotNull(encryptor);
        this.textEncryptor = new TextEncryptor(encryptor);
    }

    public SecureConfig(TextEncryptor textEncryptor) {
        AssertUtils.assertNotNull(textEncryptor);
        this.textEncryptor = textEncryptor;
    }

    @Override
    public SecureConfig load(InputStream is) throws IOException {
        super.load(is);
        return this;
    }

    @Override
    public SecureConfig load(Reader r) throws IOException {
        super.load(r);
        return this;
    }

    @Override
    public SecureConfig load(File file) throws IOException {
        super.load(file);
        return this;
    }

    @Override
    public SecureConfig load(String file) throws IOException {
        super.load(file);
        return this;
    }

    @Override
    public String getString(String key) {
        String value = super.getString(key);
        if (value == null) {
            return null;
        }
        if (!SecureConfig.isEncryptedValue(value)) {
            return value;
        }
        return this.textEncryptor.decrypt(SecureConfig.parseEncryptedValue(value));
    }

    public void puts(String key, String value) throws CryptoException {
        this.doPut(key, (value = StringUtils.trimToNull(value)) != null ? SecureConfig.markEncryptedValue(this.textEncryptor.encrypt(value)) : null);
    }

    public void puts(String key, boolean value) throws CryptoException {
        this.doPut(key, SecureConfig.markEncryptedValue(this.textEncryptor.encrypt(Boolean.toString(value))));
    }

    public void puts(String key, int value) throws CryptoException {
        this.doPut(key, SecureConfig.markEncryptedValue(this.textEncryptor.encrypt(Integer.toString(value))));
    }

    public void puts(String key, long value) throws CryptoException {
        this.doPut(key, SecureConfig.markEncryptedValue(this.textEncryptor.encrypt(Long.toString(value))));
    }

    public void puts(String key, float value) throws CryptoException {
        this.doPut(key, SecureConfig.markEncryptedValue(this.textEncryptor.encrypt(Float.toString(value))));
    }

    public void puts(String key, double value) throws CryptoException {
        this.doPut(key, SecureConfig.markEncryptedValue(this.textEncryptor.encrypt(Double.toString(value))));
    }

    public void puts(String key, Object value) throws CryptoException {
        String valueAsString = this.toStringValue(value);
        this.doPut(key, valueAsString != null ? SecureConfig.markEncryptedValue(this.textEncryptor.encrypt(valueAsString)) : null);
    }

    private static String markEncryptedValue(String value) {
        return ENC_BEGIN + value + ENC_END;
    }

    private static boolean isEncryptedValue(String value) {
        return value.startsWith(ENC_BEGIN) && value.endsWith(ENC_END);
    }

    private static String parseEncryptedValue(String value) {
        return value.substring(ENC_BEGIN.length(), value.length() - ENC_END.length());
    }
}

