/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.PasswordUtil;
import com.appslandia.common.utils.RandomUtils;
import com.appslandia.common.utils.ValueUtils;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class SecretKeyGenerator
extends InitializeObject {
    public static final SecretKeyGenerator PBKDF2_HMACSHA256 = new SecretKeyGenerator("PBKDF2WithHmacSHA256");
    public static final SecretKeyGenerator PBKDF2_HMACSHA512 = new SecretKeyGenerator("PBKDF2WithHmacSHA512");
    private String algorithm;
    private String provider;
    private SecretKeyFactory secretKeyFactory;
    final Object mutex = new Object();

    public SecretKeyGenerator() {
    }

    public SecretKeyGenerator(String algorithm) {
        this.algorithm = algorithm;
    }

    public SecretKeyGenerator(String algorithm, String provider) {
        this.algorithm = algorithm;
        this.provider = provider;
    }

    @Override
    protected void init() throws Exception {
        this.algorithm = ValueUtils.valueOrAlt(this.algorithm, "PBKDF2WithHmacSHA256");
        this.secretKeyFactory = this.provider == null ? SecretKeyFactory.getInstance(this.algorithm) : SecretKeyFactory.getInstance(this.algorithm, this.provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generate(char[] password, byte[] salt, int iterationCount, int keySize) throws CryptoException {
        this.initialize();
        PBEKeySpec keySpec = new PBEKeySpec(password, salt, iterationCount, keySize * 8);
        SecretKey secretkey = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                secretkey = this.secretKeyFactory.generateSecret(keySpec);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            keySpec.clearPassword();
        }
        byte[] key = secretkey.getEncoded();
        CryptoUtils.destroyQuietly(secretkey);
        return key;
    }

    public SecretKeyGenerator setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = algorithm;
        return this;
    }

    public SecretKeyGenerator setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }

    public SecretKeyGenerator copy() {
        return new SecretKeyGenerator().setAlgorithm(this.algorithm).setProvider(this.provider);
    }

    public static byte[] generate(int keySize) {
        char[] password = PasswordUtil.generatePassword(24);
        byte[] key = PBKDF2_HMACSHA512.generate(password, RandomUtils.nextBytes(keySize), 10000, keySize);
        CryptoUtils.clear(password);
        return key;
    }
}

