/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.RoundRobinPool;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ValueUtils;

public class PoolDigester
extends InitializeObject
implements Digester {
    private Digester digester;
    private int poolSize;
    private Digester[] digesters;
    private RoundRobinPool<Digester> digesterPool;

    public PoolDigester() {
    }

    public PoolDigester(Digester digester) {
        this.digester = digester;
    }

    public PoolDigester(Digester digester, int poolSize) {
        this.digester = digester;
        this.poolSize = poolSize;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.digester, "digester is required.");
        this.poolSize = ValueUtils.valueOrMin(this.poolSize, Runtime.getRuntime().availableProcessors());
        this.digesters = new Digester[this.poolSize];
        this.digesters[0] = this.digester;
        for (int i = 1; i < this.poolSize; ++i) {
            this.digesters[i] = this.digester.copy();
        }
        this.digesterPool = new RoundRobinPool<Digester>(this.digesters);
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.digesters != null) {
            for (Digester digester : this.digesters) {
                digester.destroy();
            }
        }
    }

    @Override
    public int getDigestSize() {
        this.initialize();
        return this.digester.getDigestSize();
    }

    @Override
    public byte[] digest(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        return this.digesterPool.next().digest(message);
    }

    @Override
    public boolean verify(byte[] message, byte[] digested) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(digested, "digested is required.");
        return this.digesterPool.next().verify(message, digested);
    }

    public PoolDigester setDigester(Digester digester) {
        this.assertNotInitialized();
        this.digester = digester;
        return this;
    }

    public PoolDigester setPoolSize(int poolSize) {
        this.assertNotInitialized();
        this.poolSize = poolSize;
        return this;
    }

    @Override
    public PoolDigester copy() {
        PoolDigester impl = new PoolDigester().setPoolSize(this.poolSize);
        if (this.digester != null) {
            impl.digester = this.digester.copy();
        }
        return impl;
    }
}

