/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.SecretKeyGenerator;
import com.appslandia.common.crypto.SecureString;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ValueUtils;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class PbeObject
extends InitializeObject {
    protected int saltSize;
    protected int iterationCount;
    protected int keySize;
    protected Object password;
    protected SecretKeyGenerator secretKeyGenerator;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertTrue(this.keySize > 0, "keySize is required.");
        this.saltSize = ValueUtils.valueOrAlt(this.saltSize, this.keySize);
        this.iterationCount = ValueUtils.valueOrMin(this.iterationCount, 10000);
        AssertUtils.assertNotNull(this.password, "password is required.");
        if (this.secretKeyGenerator == null) {
            this.secretKeyGenerator = new SecretKeyGenerator();
        }
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.password != null) {
            if (this.password instanceof SecureString) {
                CryptoUtils.destroyQuietly(this.password);
            } else {
                CryptoUtils.clear((char[])this.password);
            }
        }
    }

    protected SecretKey buildSecretKey(final byte[] salt, final String algorithm) throws CryptoException {
        if (this.password instanceof SecureString) {
            return ((SecureString)this.password).access(new SecureString.Accessor<SecretKey>(){

                @Override
                public SecretKey access(char[] password) throws CryptoException {
                    byte[] key = PbeObject.this.secretKeyGenerator.generate(password, salt, PbeObject.this.iterationCount, PbeObject.this.keySize);
                    SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
                    CryptoUtils.clear(key);
                    return secretKey;
                }
            });
        }
        byte[] key = this.secretKeyGenerator.generate((char[])this.password, salt, this.iterationCount, this.keySize);
        SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
        CryptoUtils.clear(key);
        return secretKey;
    }

    public PbeObject setSaltSize(int saltSize) {
        this.assertNotInitialized();
        this.saltSize = saltSize;
        return this;
    }

    public PbeObject setIterationCount(int iterationCount) {
        this.assertNotInitialized();
        this.iterationCount = iterationCount;
        return this;
    }

    public PbeObject setKeySize(int keySize) {
        this.assertNotInitialized();
        this.keySize = keySize;
        return this;
    }

    public PbeObject setSecurePassword(SecureString password) {
        this.assertNotInitialized();
        if (password != null) {
            this.password = password.copy();
        }
        return this;
    }

    public PbeObject setSecurePassword(char[] password) {
        this.assertNotInitialized();
        if (password != null) {
            this.password = new SecureString(password);
        }
        return this;
    }

    public PbeObject setPassword(char[] password) {
        this.assertNotInitialized();
        if (password != null) {
            this.password = Arrays.copyOf(password, password.length);
        }
        return this;
    }

    public PbeObject setSecretKeyGenerator(SecretKeyGenerator secretKeyGenerator) {
        this.assertNotInitialized();
        this.secretKeyGenerator = secretKeyGenerator;
        return this;
    }
}

