/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.PbeObject;
import com.appslandia.common.crypto.SecretKeyGenerator;
import com.appslandia.common.crypto.SecureString;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.RandomUtils;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public class PbeMacDigester
extends PbeObject
implements Digester {
    private String algorithm;
    private String provider;
    private Mac mac;
    final Object mutex = new Object();
    final Random random = new SecureRandom();

    @Override
    protected void init() throws Exception {
        super.init();
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        this.mac = this.provider == null ? Mac.getInstance(this.algorithm) : Mac.getInstance(this.algorithm, this.provider);
    }

    @Override
    public int getDigestSize() {
        this.initialize();
        return this.saltSize + this.mac.getMacLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] digest(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        byte[] salt = RandomUtils.nextBytes(this.saltSize, this.random);
        SecretKey secretKey = this.buildSecretKey(salt, this.algorithm);
        try {
            byte[] msgMac = null;
            Object object = this.mutex;
            synchronized (object) {
                this.mac.init(secretKey);
                msgMac = this.mac.doFinal(message);
            }
            object = ArrayUtils.append(salt, msgMac);
            return object;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            CryptoUtils.destroyQuietly(secretKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(byte[] message, byte[] mac) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(mac, "mac is required.");
        AssertUtils.assertTrue(mac.length > this.saltSize, "mac is invalid.");
        byte[] salt = new byte[this.saltSize];
        ArrayUtils.copy(mac, salt);
        SecretKey secretKey = this.buildSecretKey(salt, this.algorithm);
        try {
            byte[] msgMac = null;
            Object object = this.mutex;
            synchronized (object) {
                this.mac.init(secretKey);
                msgMac = this.mac.doFinal(message);
            }
            boolean bl = ArrayUtils.contains(mac, msgMac, this.saltSize);
            return bl;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            CryptoUtils.destroyQuietly(secretKey);
        }
    }

    public PbeMacDigester setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = algorithm;
        return this;
    }

    public PbeMacDigester setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }

    @Override
    public PbeMacDigester setSaltSize(int saltSize) {
        super.setSaltSize(saltSize);
        return this;
    }

    @Override
    public PbeMacDigester setIterationCount(int iterationCount) {
        super.setIterationCount(iterationCount);
        return this;
    }

    @Override
    public PbeMacDigester setKeySize(int keySize) {
        super.setKeySize(keySize);
        return this;
    }

    @Override
    public PbeMacDigester setSecurePassword(SecureString password) {
        super.setSecurePassword(password);
        return this;
    }

    @Override
    public PbeMacDigester setSecurePassword(char[] password) {
        super.setSecurePassword(password);
        return this;
    }

    @Override
    public PbeMacDigester setPassword(char[] password) {
        super.setPassword(password);
        return this;
    }

    @Override
    public PbeMacDigester setSecretKeyGenerator(SecretKeyGenerator secretKeyGenerator) {
        super.setSecretKeyGenerator(secretKeyGenerator);
        return this;
    }

    @Override
    public PbeMacDigester copy() {
        PbeMacDigester impl = new PbeMacDigester().setAlgorithm(this.algorithm).setProvider(this.provider);
        impl.setSaltSize(this.saltSize).setIterationCount(this.iterationCount).setKeySize(this.keySize);
        if (this.password != null) {
            if (this.password instanceof SecureString) {
                impl.password = ((SecureString)this.password).copy();
            } else {
                impl.setPassword((char[])this.password);
            }
        }
        if (this.secretKeyGenerator != null) {
            impl.secretKeyGenerator = this.secretKeyGenerator.copy();
        }
        return impl;
    }
}

