/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.crypto.PbeObject;
import com.appslandia.common.crypto.SecretKeyGenerator;
import com.appslandia.common.crypto.SecureString;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.RandomUtils;
import com.appslandia.common.utils.ValueUtils;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class PbeEncryptor
extends PbeObject
implements Encryptor {
    private String transformation;
    private String provider;
    private int gcmTagSize;
    private String algorithm;
    private String mode;
    private int ivSize;
    private Cipher cipher;
    final Object mutex = new Object();
    final Random random = new SecureRandom();
    static final ConcurrentMap<Integer, byte[]> ZERO_IV_CACHE = new ConcurrentHashMap<Integer, byte[]>();

    @Override
    protected void init() throws Exception {
        super.init();
        AssertUtils.assertNotNull(this.transformation, "transformation is required.");
        String[] trans = this.transformation.split("/");
        this.algorithm = trans[0].toUpperCase(Locale.ENGLISH);
        AssertUtils.assertFalse("RSA".equals(this.algorithm), "RSA algorithm is not supported.");
        String string = this.mode = trans.length > 1 ? trans[1].toUpperCase(Locale.ENGLISH) : null;
        if ("GCM".equals(this.mode)) {
            this.gcmTagSize = ValueUtils.valueOrAlt(this.gcmTagSize, 16);
        }
        this.cipher = this.provider == null ? Cipher.getInstance(this.transformation) : Cipher.getInstance(this.transformation, this.provider);
        if (this.mode != null) {
            this.ivSize = this.requiresIV(this.mode) ? ("GCM".equals(this.mode) ? 12 : this.cipher.getBlockSize()) : 0;
        }
    }

    protected boolean requiresIV(String mode) {
        return "CBC".equals(mode) || "GCM".equals(mode) || "CTR".equals(mode) || "CTS".equals(mode) || "PCBC".equals(mode) || mode.startsWith("CFB") || mode.startsWith("OFB");
    }

    protected AlgorithmParameterSpec buildIvParameter(byte[] iv) {
        if ("GCM".equals(this.mode)) {
            return new GCMParameterSpec(this.gcmTagSize * 8, iv);
        }
        return new IvParameterSpec(iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        byte[] iv = null;
        if (this.ivSize > 0) {
            iv = ZERO_IV_CACHE.computeIfAbsent(this.ivSize, s -> new byte[s.intValue()]);
        }
        byte[] salt = RandomUtils.nextBytes(this.saltSize, this.random);
        SecretKey secretKey = this.buildSecretKey(salt, this.algorithm);
        try {
            byte[] encMsg = null;
            Object object = this.mutex;
            synchronized (object) {
                if (iv != null) {
                    this.cipher.init(1, (Key)secretKey, this.buildIvParameter(iv));
                } else {
                    this.cipher.init(1, secretKey);
                }
                encMsg = this.cipher.doFinal(message);
            }
            object = ArrayUtils.append(salt, encMsg);
            return object;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        finally {
            CryptoUtils.destroyQuietly(secretKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        byte[] iv = null;
        if (this.ivSize > 0) {
            iv = ZERO_IV_CACHE.computeIfAbsent(this.ivSize, s -> new byte[s.intValue()]);
        }
        AssertUtils.assertTrue(message.length > this.saltSize, "message is invalid.");
        byte[] salt = new byte[this.saltSize];
        ArrayUtils.copy(message, salt);
        SecretKey secretKey = this.buildSecretKey(salt, this.algorithm);
        try {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    if (iv != null) {
                        this.cipher.init(2, (Key)secretKey, this.buildIvParameter(iv));
                    } else {
                        this.cipher.init(2, secretKey);
                    }
                    byte[] byArray = this.cipher.doFinal(message, this.saltSize, message.length - this.saltSize);
                    return byArray;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (GeneralSecurityException ex) {
                        throw new CryptoException(ex);
                    }
                }
            }
        }
        finally {
            CryptoUtils.destroyQuietly(secretKey);
        }
    }

    public int getIvSize() {
        this.initialize();
        return this.ivSize;
    }

    public PbeEncryptor setTransformation(String transformation) {
        this.assertNotInitialized();
        this.transformation = transformation;
        return this;
    }

    public PbeEncryptor setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }

    @Override
    public PbeEncryptor setSaltSize(int saltSize) {
        super.setSaltSize(saltSize);
        return this;
    }

    @Override
    public PbeEncryptor setIterationCount(int iterationCount) {
        super.setIterationCount(iterationCount);
        return this;
    }

    @Override
    public PbeEncryptor setKeySize(int keySize) {
        super.setKeySize(keySize);
        return this;
    }

    @Override
    public PbeEncryptor setSecurePassword(SecureString password) {
        super.setSecurePassword(password);
        return this;
    }

    @Override
    public PbeEncryptor setSecurePassword(char[] password) {
        super.setSecurePassword(password);
        return this;
    }

    @Override
    public PbeEncryptor setPassword(char[] password) {
        super.setPassword(password);
        return this;
    }

    @Override
    public PbeEncryptor setSecretKeyGenerator(SecretKeyGenerator secretKeyGenerator) {
        super.setSecretKeyGenerator(secretKeyGenerator);
        return this;
    }

    public PbeEncryptor setGcmTagSize(int gcmTagSize) {
        this.assertNotInitialized();
        this.gcmTagSize = gcmTagSize;
        return this;
    }

    @Override
    public PbeEncryptor copy() {
        PbeEncryptor impl = new PbeEncryptor().setTransformation(this.transformation).setProvider(this.provider);
        impl.setSaltSize(this.saltSize).setIterationCount(this.iterationCount).setKeySize(this.keySize);
        if (this.password != null) {
            if (this.password instanceof SecureString) {
                impl.password = ((SecureString)this.password).copy();
            } else {
                impl.setPassword((char[])this.password);
            }
        }
        if (this.secretKeyGenerator != null) {
            impl.secretKeyGenerator = this.secretKeyGenerator.copy();
        }
        impl.gcmTagSize = this.gcmTagSize;
        return impl;
    }
}

