/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharsetUtils;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class MacDigester
extends InitializeObject
implements Digester {
    private String algorithm;
    private String provider;
    private Mac mac;
    private byte[] secret;
    final Object mutex = new Object();
    final Random random = new SecureRandom();

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        AssertUtils.assertNotNull(this.secret, "secret is required.");
        this.mac = this.provider == null ? Mac.getInstance(this.algorithm) : Mac.getInstance(this.algorithm, this.provider);
        this.mac.init(new SecretKeySpec(this.secret, this.algorithm));
        CryptoUtils.clear(this.secret);
    }

    @Override
    public int getDigestSize() {
        this.initialize();
        return this.mac.getMacLength();
    }

    @Override
    public void destroy() throws DestroyException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] digest(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        Object object = this.mutex;
        synchronized (object) {
            return this.mac.doFinal(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(byte[] message, byte[] mac) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(mac, "mac is required.");
        byte[] msgMac = null;
        Object object = this.mutex;
        synchronized (object) {
            msgMac = this.mac.doFinal(message);
        }
        return Arrays.equals(msgMac, mac);
    }

    public MacDigester setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = algorithm;
        return this;
    }

    public MacDigester setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }

    public MacDigester setSecret(byte[] secret) {
        this.assertNotInitialized();
        this.secret = ArrayUtils.copy(secret);
        return this;
    }

    public MacDigester setSecret(String secret) {
        AssertUtils.assertNotNull(secret);
        return this.setSecret(secret.getBytes(CharsetUtils.UTF_8));
    }

    @Override
    public MacDigester copy() {
        MacDigester impl = new MacDigester().setAlgorithm(this.algorithm).setProvider(this.provider);
        impl.secret = ArrayUtils.copy(this.secret);
        return impl;
    }
}

