/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.CryptoUtils;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.KeyFactoryUtil;
import com.appslandia.common.utils.AssertUtils;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public class DsaDigester
extends InitializeObject
implements Digester {
    private String algorithm;
    private String provider;
    private Signature sign;
    private Signature ver;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    final Object verMutex = new Object();

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        AssertUtils.assertTrue(this.privateKey != null || this.publicKey != null, "No key is provided.");
        if (this.privateKey != null) {
            this.sign = this.provider == null ? Signature.getInstance(this.algorithm) : Signature.getInstance(this.algorithm, this.provider);
            this.sign.initSign(this.privateKey);
        }
        if (this.publicKey != null) {
            this.ver = this.provider == null ? Signature.getInstance(this.algorithm) : Signature.getInstance(this.algorithm, this.provider);
            this.ver.initVerify(this.publicKey);
        }
    }

    @Override
    public void destroy() throws DestroyException {
        CryptoUtils.destroyQuietly(this.privateKey);
    }

    @Override
    public int getDigestSize() {
        this.initialize();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] digest(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(this.sign, "privateKey is required.");
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.sign.update(message);
                return this.sign.sign();
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(byte[] message, byte[] signature) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(signature, "signature is required.");
        AssertUtils.assertNotNull(this.ver, "publicKey is required.");
        try {
            Object object = this.verMutex;
            synchronized (object) {
                this.ver.update(message);
                return this.ver.verify(signature);
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
    }

    public DsaDigester setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = algorithm;
        return this;
    }

    public DsaDigester setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }

    public DsaDigester setPrivateKey(PrivateKey privateKey) {
        this.assertNotInitialized();
        this.privateKey = privateKey;
        return this;
    }

    public DsaDigester setPrivateKey(String privateKeyPem) {
        this.assertNotInitialized();
        if (privateKeyPem != null) {
            this.privateKey = KeyFactoryUtil.DSA.toPrivateKey(privateKeyPem);
        }
        return this;
    }

    public DsaDigester setPublicKey(PublicKey publicKey) {
        this.assertNotInitialized();
        this.publicKey = publicKey;
        return this;
    }

    public DsaDigester setPublicKey(String publicKeyPem) {
        this.assertNotInitialized();
        if (publicKeyPem != null) {
            this.publicKey = KeyFactoryUtil.DSA.toPublicKey(publicKeyPem);
        }
        return this;
    }

    @Override
    public DsaDigester copy() {
        DsaDigester impl = new DsaDigester().setAlgorithm(this.algorithm).setProvider(this.provider);
        if (this.privateKey != null) {
            impl.privateKey = new KeyFactoryUtil(this.privateKey.getAlgorithm()).copy(this.privateKey);
        }
        impl.publicKey = this.publicKey;
        return impl;
    }
}

