/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.utils.AssertUtils;
import java.security.MessageDigest;
import java.util.Arrays;

public class DigesterImpl
extends InitializeObject
implements Digester {
    private String algorithm;
    private String provider;
    private MessageDigest digest;
    final Object mutex = new Object();

    public DigesterImpl() {
    }

    public DigesterImpl(String algorithm) {
        this.algorithm = algorithm;
    }

    public DigesterImpl(String algorithm, String provider) {
        this.algorithm = algorithm;
        this.provider = provider;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.algorithm, "algorithm is required.");
        this.digest = this.provider == null ? MessageDigest.getInstance(this.algorithm) : MessageDigest.getInstance(this.algorithm, this.provider);
    }

    @Override
    public int getDigestSize() {
        this.initialize();
        return this.digest.getDigestLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] digest(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        Object object = this.mutex;
        synchronized (object) {
            return this.digest.digest(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(byte[] message, byte[] digested) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(digested, "digested is required.");
        byte[] digest = null;
        Object object = this.mutex;
        synchronized (object) {
            digest = this.digest.digest(message);
        }
        return Arrays.equals(digested, digest);
    }

    public DigesterImpl setAlgorithm(String algorithm) {
        this.assertNotInitialized();
        this.algorithm = algorithm;
        return this;
    }

    public DigesterImpl setProvider(String provider) {
        this.assertNotInitialized();
        this.provider = provider;
        return this;
    }

    @Override
    public DigesterImpl copy() {
        return new DigesterImpl().setAlgorithm(this.algorithm).setProvider(this.provider);
    }
}

