/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.TextGenerator;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharUtils;
import com.appslandia.common.utils.RandomUtils;
import com.appslandia.common.utils.ValueUtils;
import java.security.SecureRandom;
import java.util.Random;
import java.util.regex.Pattern;

public class WordsGenerator
extends InitializeObject
implements TextGenerator {
    private static final char[] ALPHABET_LOWER = CharUtils.toCharRanges("a-z");
    private static final char[] ALPHABET_UPPER = CharUtils.toCharRanges("A-Z");
    private static final char[] ALPHABET_DIGITS = CharUtils.toCharRanges("0-9");
    private static final Pattern DIGITS_PATTERN = Pattern.compile("[\\d]+");
    private static final Pattern DIGITS_AZ_PATTERN = Pattern.compile("[a-zA-Z\\d]+");
    private static final Pattern DIGITS_AZ_LOWER_PATTERN = Pattern.compile("[a-z\\d]+");
    private static final Pattern DIGITS_AZ_UPPER_PATTERN = Pattern.compile("[A-Z\\d]+");
    private int length;
    private Alphabet alphabet;
    final Random random = new SecureRandom();

    @Override
    protected void init() throws Exception {
        AssertUtils.assertTrue(this.length > 0, "length is required.");
        this.alphabet = ValueUtils.valueOrAlt(this.alphabet, Alphabet.DIGITS_AZ);
    }

    @Override
    public String generate() {
        this.initialize();
        switch (this.alphabet) {
            case DIGITS_AZ: {
                return this.generate(new char[][]{ALPHABET_DIGITS, ALPHABET_UPPER, ALPHABET_LOWER});
            }
            case DIGITS_AZ_UPPER: {
                return this.generate(new char[][]{ALPHABET_DIGITS, ALPHABET_UPPER});
            }
            case DIGITS_AZ_LOWER: {
                return this.generate(new char[][]{ALPHABET_DIGITS, ALPHABET_LOWER});
            }
        }
        return this.generate(new char[][]{ALPHABET_DIGITS});
    }

    private String generate(char[][] sources) {
        int[] sourceIndexes;
        int len = Math.max(this.length, sources.length);
        char[] rdChars = new char[len];
        int avgLen = len / sources.length;
        int emptyCount = len;
        for (int index : sourceIndexes = RandomUtils.nextIndexes(sources.length, this.random)) {
            int rdCount = RandomUtils.nextInt(1, avgLen, this.random);
            emptyCount = WordsGenerator.randomChars(this.random, sources[index], rdChars, rdCount, emptyCount);
        }
        for (int i = 0; i < len; ++i) {
            if (rdChars[i] != '\u0000') continue;
            char[] nextSource = sources[this.random.nextInt(sources.length)];
            rdChars[i] = nextSource[this.random.nextInt(nextSource.length)];
        }
        return new String(rdChars, 0, this.length);
    }

    @Override
    public boolean verify(String value) {
        AssertUtils.assertNotNull(value);
        if (value.length() != this.length) {
            return false;
        }
        switch (this.alphabet) {
            case DIGITS_AZ: {
                return DIGITS_AZ_PATTERN.matcher(value).matches();
            }
            case DIGITS_AZ_UPPER: {
                return DIGITS_AZ_UPPER_PATTERN.matcher(value).matches();
            }
            case DIGITS_AZ_LOWER: {
                return DIGITS_AZ_LOWER_PATTERN.matcher(value).matches();
            }
        }
        return DIGITS_PATTERN.matcher(value).matches();
    }

    public WordsGenerator setLength(int length) {
        this.assertNotInitialized();
        this.length = length;
        return this;
    }

    public WordsGenerator setAlphabet(Alphabet alphabet) {
        this.assertNotInitialized();
        this.alphabet = alphabet;
        return this;
    }

    public static int randomChars(Random random, char[] src, char[] dest, int rdCount, int emptyCount) {
        for (int i = 0; i < rdCount; ++i) {
            int index = WordsGenerator.randomEmptyIndex(random, dest, emptyCount);
            dest[index] = src[random.nextInt(src.length)];
            --emptyCount;
        }
        return emptyCount;
    }

    private static int randomEmptyIndex(Random random, char[] dest, int emptyCount) {
        int rdIndex = random.nextInt(emptyCount);
        int idx = -1;
        for (int i = 0; i < dest.length; ++i) {
            if (dest[i] != '\u0000' || ++idx != rdIndex) continue;
            return i;
        }
        return 0;
    }

    public static enum Alphabet {
        DIGITS,
        DIGITS_AZ_UPPER,
        DIGITS_AZ_LOWER,
        DIGITS_AZ;

    }
}

