/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.utils.DateUtils;
import com.appslandia.common.utils.StringUtils;
import com.appslandia.common.utils.URLEncoding;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.regex.Pattern;

public class ValuesEncoder {
    private static final String NULL_VAL = "null";
    final StringBuilder sb = new StringBuilder();

    protected void addVal(String encodedVal) {
        if (this.sb.length() > 0) {
            this.sb.append(',');
        }
        this.sb.append(encodedVal);
    }

    public ValuesEncoder add(String value) {
        this.addVal(!StringUtils.isNullOrEmpty(value) ? URLEncoding.encodeParam(value) : NULL_VAL);
        return this;
    }

    public ValuesEncoder add(boolean value) {
        this.addVal(Boolean.toString(value));
        return this;
    }

    public ValuesEncoder add(int value) {
        this.addVal(Integer.toString(value));
        return this;
    }

    public ValuesEncoder add(long value) {
        this.addVal(Long.toString(value));
        return this;
    }

    public ValuesEncoder add(float value) {
        this.addVal(Float.toString(value));
        return this;
    }

    public ValuesEncoder add(double value) {
        this.addVal(Double.toString(value));
        return this;
    }

    public ValuesEncoder add(Object value) {
        this.addVal(ValuesEncoder.toStringValue(value));
        return this;
    }

    public String toEncoded() {
        String values = this.sb.toString();
        return !values.isEmpty() ? values : null;
    }

    public static String[] parse(String encoded) throws IllegalArgumentException {
        if (StringUtils.isNullOrEmpty(encoded)) {
            return StringUtils.EMPTY_ARRAY;
        }
        String[] values = encoded.split(Pattern.quote(","));
        for (int i = 0; i < values.length; ++i) {
            values[i] = !NULL_VAL.equals(values[i]) ? URLEncoding.decodeParam(values[i]) : null;
        }
        return values;
    }

    private static String toStringValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return DateUtils.iso8601Date((Date)value);
        }
        if (value instanceof Time) {
            return DateUtils.iso8601Time((Time)value);
        }
        if (value instanceof Timestamp) {
            return DateUtils.iso8601DateTime((Timestamp)value);
        }
        return value.toString();
    }
}

