/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Provider;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ReflectionUtils;
import com.appslandia.common.utils.StringUtils;
import java.util.Locale;

public class Language
extends InitializeObject {
    public static final Language EN = new Language().setLocale(Locale.US).setPatternDate("MM/dd/yyyy");
    public static final Language VI = new Language().setLocale(new Locale("vi", "VN")).setPatternDate("dd/MM/yyyy");
    private Locale locale;
    private String patternDate;
    private String patternDateTime;
    private String patternDateTimeZ;
    private String patternDateTimeMI;
    private String patternDateTimeMIZ;
    private static volatile Language __default;
    private static final Object MUTEX;
    private static Provider<Language> __provider;
    public static final String SYSTEM_PROP_LANGUAGE = "language";
    public static final String SYSTEM_ENV_LANGUAGE = "APPS_LANGUAGE";

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.locale, "locale is required.");
        AssertUtils.assertNotNull(this.patternDate, "datePattern is required.");
        this.patternDateTime = String.format("%s %s", this.patternDate, "HH:mm:ss.SSS");
        this.patternDateTimeZ = String.format("%s %s", this.patternDate, "HH:mm:ss.SSSXXX");
        this.patternDateTimeMI = String.format("%s %s", this.patternDate, "HH:mm");
        this.patternDateTimeMIZ = String.format("%s %s", this.patternDate, "HH:mmXXX");
    }

    public String getId() {
        this.initialize();
        return this.locale.getLanguage();
    }

    public String getDisplayName() {
        this.initialize();
        return this.locale.getDisplayLanguage(this.locale);
    }

    public Locale getLocale() {
        this.initialize();
        return this.locale;
    }

    public Language setLocale(Locale locale) {
        this.assertNotInitialized();
        this.locale = locale;
        return this;
    }

    public String getPatternDate() {
        this.initialize();
        return this.patternDate;
    }

    public Language setPatternDate(String patternDate) {
        this.assertNotInitialized();
        this.patternDate = StringUtils.trimToNull(patternDate);
        return this;
    }

    public String getPatternDateTime() {
        this.initialize();
        return this.patternDateTime;
    }

    public String getPatternDateTimeZ() {
        this.initialize();
        return this.patternDateTimeZ;
    }

    public String getPatternDateTimeMI() {
        this.initialize();
        return this.patternDateTimeMI;
    }

    public String getPatternDateTimeMIZ() {
        this.initialize();
        return this.patternDateTimeMIZ;
    }

    public String getPatternTimeMI() {
        this.initialize();
        return "HH:mm";
    }

    public String getPatternTimeMIZ() {
        this.initialize();
        return "HH:mmXXX";
    }

    public String getPatternTime() {
        this.initialize();
        return "HH:mm:ss.SSS";
    }

    public String getPatternTimeZ() {
        this.initialize();
        return "HH:mm:ss.SSSXXX";
    }

    public int hashCode() {
        return ObjectUtils.hashCode(this.getId().toLowerCase(Locale.ENGLISH));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Language)) {
            return false;
        }
        Language another = (Language)obj;
        return this.getId().equalsIgnoreCase(another.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Language getDefault() {
        Language obj = __default;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __default;
                if (obj == null) {
                    __default = obj = Language.initLanguage();
                }
            }
        }
        return obj;
    }

    public static void setDefault(Language obj) {
        AssertUtils.assertNull(__default);
        __default = obj;
    }

    public static void setProvider(Provider<Language> provider) {
        AssertUtils.assertNull(__default);
        __provider = provider;
    }

    private static Language initLanguage() {
        if (__provider != null) {
            return __provider.get();
        }
        try {
            String implName = System.getProperty(SYSTEM_PROP_LANGUAGE);
            if (implName == null) {
                implName = System.getenv(SYSTEM_ENV_LANGUAGE);
            }
            if (implName == null) {
                return EN;
            }
            Class implClass = ReflectionUtils.loadClass(implName, null);
            return (Language)ReflectionUtils.newInstance(implClass);
        }
        catch (Exception ex) {
            throw new InitializeException(ex);
        }
    }

    static {
        MUTEX = new Object();
    }
}

