/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.base.Language;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class FormatProviderImpl
implements FormatProvider {
    protected final Language language;
    protected Map<String, SimpleDateFormat> dateFormatCache;
    protected NumberFormat integerFormat;
    protected NumberFormat numberFormat;
    protected NumberFormat bigDecimalFormat;

    public FormatProviderImpl() {
        this(Language.getDefault());
    }

    public FormatProviderImpl(Language language) {
        this.language = language;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public NumberFormat getIntegerFormat() {
        if (this.integerFormat == null) {
            this.integerFormat = NumberFormat.getIntegerInstance(this.language.getLocale());
        }
        return this.integerFormat;
    }

    @Override
    public NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getNumberInstance(this.language.getLocale());
        }
        return this.numberFormat;
    }

    @Override
    public NumberFormat getBigDecimalFormat() {
        if (this.bigDecimalFormat == null) {
            NumberFormat impl = NumberFormat.getNumberInstance(this.language.getLocale());
            if (impl instanceof DecimalFormat) {
                ((DecimalFormat)impl).setParseBigDecimal(true);
            }
            this.bigDecimalFormat = impl;
        }
        return this.bigDecimalFormat;
    }

    @Override
    public DateFormat getDateFormat(String pattern) {
        return this.getDateFormatCache().get(pattern);
    }

    protected Map<String, SimpleDateFormat> getDateFormatCache() {
        if (this.dateFormatCache == null) {
            this.dateFormatCache = new HashMap<String, SimpleDateFormat>(){
                private static final long serialVersionUID = 1L;

                @Override
                public SimpleDateFormat get(Object pattern) {
                    SimpleDateFormat impl = (SimpleDateFormat)super.get(pattern);
                    if (impl != null) {
                        return impl;
                    }
                    impl = new SimpleDateFormat((String)pattern);
                    impl.setLenient(false);
                    this.put((String)pattern, impl);
                    return impl;
                }
            };
        }
        return this.dateFormatCache;
    }
}

