/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

public class CharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;

    public CharArrayWriter() {
        this(32);
    }

    public CharArrayWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("initialSize");
        }
        this.buf = new char[initialSize];
    }

    @Override
    public void write(int c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = (char)c;
        this.count = newcount;
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count = newcount;
    }

    @Override
    public void write(String str, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        str.getChars(off, off + len, this.buf, this.count);
        this.count = newcount;
    }

    public void writeTo(Writer out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    @Override
    public CharArrayWriter append(CharSequence csq) {
        String s = csq == null ? "null" : csq.toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public CharArrayWriter append(CharSequence csq, int start, int end) {
        String s = (csq == null ? "null" : csq).subSequence(start, end).toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public CharArrayWriter append(char c) {
        this.write(c);
        return this;
    }

    public void reset() {
        this.count = 0;
    }

    public char[] toCharArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

