/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.Base64Delegate;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CharsetUtils;

public enum BaseEncoder {
    BASE64,
    BASE64_NP,
    BASE64_URL,
    BASE64_URL_NP,
    BASE64_MIME,
    BASE64_MIME_NP;


    public String encode(byte[] message) {
        AssertUtils.assertNotNull(message);
        switch (this) {
            case BASE64: {
                return new String(Base64Delegate.getDefault().encode(message), CharsetUtils.ISO_8859_1);
            }
            case BASE64_URL_NP: {
                return new String(Base64Delegate.getDefault().urlEncodeNP(message), CharsetUtils.ISO_8859_1);
            }
            case BASE64_NP: {
                return new String(Base64Delegate.getDefault().encodeNP(message), CharsetUtils.ISO_8859_1);
            }
            case BASE64_MIME: {
                return new String(Base64Delegate.getDefault().mimeEncode(message), CharsetUtils.ISO_8859_1);
            }
            case BASE64_MIME_NP: {
                return new String(Base64Delegate.getDefault().mimeEncodeNP(message), CharsetUtils.ISO_8859_1);
            }
            case BASE64_URL: {
                return new String(Base64Delegate.getDefault().urlEncode(message), CharsetUtils.ISO_8859_1);
            }
        }
        throw new UnsupportedOperationException();
    }

    public byte[] decode(String encoded) throws IllegalArgumentException {
        AssertUtils.assertNotNull(encoded);
        switch (this) {
            case BASE64: {
                return Base64Delegate.getDefault().decode(encoded.getBytes(CharsetUtils.ISO_8859_1));
            }
            case BASE64_URL_NP: {
                return Base64Delegate.getDefault().urlDecode(encoded.getBytes(CharsetUtils.ISO_8859_1));
            }
            case BASE64_NP: {
                return Base64Delegate.getDefault().decode(encoded.getBytes(CharsetUtils.ISO_8859_1));
            }
            case BASE64_MIME: {
                return Base64Delegate.getDefault().mimeDecode(encoded.getBytes(CharsetUtils.ISO_8859_1));
            }
            case BASE64_MIME_NP: {
                return Base64Delegate.getDefault().mimeDecode(encoded.getBytes(CharsetUtils.ISO_8859_1));
            }
            case BASE64_URL: {
                return Base64Delegate.getDefault().urlDecode(encoded.getBytes(CharsetUtils.ISO_8859_1));
            }
        }
        throw new UnsupportedOperationException();
    }
}

