/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.base;

import com.appslandia.common.base.InitializeException;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ReflectionUtils;

public abstract class Base64Delegate {
    private static volatile Base64Delegate __default;
    private static final Object MUTEX;

    public abstract byte[] encode(byte[] var1);

    public abstract byte[] encodeNP(byte[] var1);

    public abstract byte[] decode(byte[] var1) throws IllegalArgumentException;

    public abstract byte[] urlEncode(byte[] var1);

    public abstract byte[] urlEncodeNP(byte[] var1);

    public abstract byte[] urlDecode(byte[] var1) throws IllegalArgumentException;

    public abstract byte[] mimeEncode(byte[] var1);

    public abstract byte[] mimeEncodeNP(byte[] var1);

    public abstract byte[] mimeDecode(byte[] var1) throws IllegalArgumentException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Base64Delegate getDefault() {
        Base64Delegate obj = __default;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __default;
                if (obj == null) {
                    __default = obj = Base64Delegate.initBase64Delegate();
                }
            }
        }
        return obj;
    }

    public static void setDefault(Base64Delegate obj) {
        AssertUtils.assertNull(__default);
        __default = obj;
    }

    private static Base64Delegate initBase64Delegate() {
        try {
            Class implClass = ReflectionUtils.loadClass("com.appslandia.common.base.Jdk8Base64Delegate", null);
            return (Base64Delegate)ReflectionUtils.newInstance(implClass);
        }
        catch (Exception ex) {
            throw new InitializeException(ex);
        }
    }

    static {
        MUTEX = new Object();
    }
}

