// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.utils;

import java.util.Arrays;

/**
 *
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public class NumberUtils {

	public static String formatLeadingZero(long num, int length) {
		AssertUtils.assertTrue(num >= 0);
		char[] out = new char[length];
		Arrays.fill(out, '0');
		if (num == 0) {
			return new String(out);
		}
		int idx = length;
		while (true) {
			short m = (short) (num % 10);
			idx -= 1;
			if (idx < 0) {
				throw new IllegalArgumentException("length is not big enough.");
			}
			out[idx] = (char) ('0' + m);
			num = num / 10;
			if (num == 0) {
				break;
			}
		}
		return new String(out);
	}

	public static int compare(int c1, int c2) {
		if (c1 > c2) {
			return 1;
		}
		if (c1 < c2) {
			return -1;
		}
		return 0;
	}
}
