// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.appslandia.common.base.Config;
import com.appslandia.common.base.ConfigMap;
import com.appslandia.common.base.ConfigWrapper;

/**
 *
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public class CLIUtils {

	// GNU Format
	private static final String ARG_ENTRY = "--[a-z][a-z\\d]*(=[^\\s]+)?";
	private static final Pattern ARG_ENTRY_PATTERN = Pattern.compile(ARG_ENTRY, Pattern.CASE_INSENSITIVE);

	public static Config parseArgs(String[] args) throws IllegalArgumentException {
		ConfigMap argMap = new ConfigMap();
		for (String arg : args) {
			if (ARG_ENTRY_PATTERN.matcher(arg).matches()) {
				int idx = arg.indexOf('=');
				if (idx < 0) {
					argMap.put(arg.substring(2), String.valueOf(true));
				} else {

					argMap.put(arg.substring(2, idx), arg.substring(idx + 1));
				}
			} else {
				throw new IllegalArgumentException("arg=" + arg);
			}
		}
		return new ConfigWrapper(argMap);
	}

	private static final Pattern ARG_ENTRIES_PATTERN = Pattern.compile(String.format("%s(\\s+%s)*", ARG_ENTRY, ARG_ENTRY), Pattern.CASE_INSENSITIVE);

	public static Config parseArgs(String args) {
		args = StringUtils.trimToNull(args);
		if (args == null) {
			return new ConfigWrapper(new ConfigMap());
		}
		if (!ARG_ENTRIES_PATTERN.matcher(args).matches()) {
			throw new IllegalArgumentException("args is invalid (value=" + args + ")");
		}
		Matcher matcher = ARG_ENTRY_PATTERN.matcher(args);
		List<String> argList = new ArrayList<>();
		while (matcher.find()) {
			argList.add(matcher.group());
		}
		return parseArgs(argList.toArray(new String[argList.size()]));
	}
}
