// The MIT License (MIT)
// Copyright © 2015 AppsLandia. All rights reserved.

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package com.appslandia.common.base;

/**
 *
 * @author <a href="mailto:haducloc13@gmail.com">Loc Ha</a>
 *
 */
public class ConfigWrapper implements Config {

	final Config cfg;

	public ConfigWrapper(Config cfg) {
		this.cfg = cfg;
	}

	// com.appslandia.common.base.Config

	@Override
	public boolean getBool(java.lang.String key, boolean defaultValue) {
		return this.cfg.getBool(key, defaultValue);
	}

	@Override
	public java.sql.Date getDate(java.lang.String key) {
		return this.cfg.getDate(key);
	}

	@Override
	public java.sql.Timestamp getDateTime(java.lang.String key) {
		return this.cfg.getDateTime(key);
	}

	@Override
	public double getDouble(java.lang.String key, double defaultValue) {
		return this.cfg.getDouble(key, defaultValue);
	}

	@Override
	public float getFloat(java.lang.String key, float defaultValue) {
		return this.cfg.getFloat(key, defaultValue);
	}

	@Override
	public java.lang.String getFormatted(java.lang.String key) {
		return this.cfg.getFormatted(key);
	}

	@Override
	public java.lang.String getFormatted(java.lang.String key, java.lang.Object... parameters) {
		return this.cfg.getFormatted(key, parameters);
	}

	@Override
	public java.lang.String getFormatted(java.lang.String key, java.util.Map<java.lang.String, java.lang.Object> parameters) {
		return this.cfg.getFormatted(key, parameters);
	}

	@Override
	public int getInt(java.lang.String key, int defaultValue) {
		return this.cfg.getInt(key, defaultValue);
	}

	@Override
	public long getLong(java.lang.String key, long defaultValue) {
		return this.cfg.getLong(key, defaultValue);
	}

	@Override
	public boolean getRequiredBool(java.lang.String key) throws java.lang.NullPointerException, com.appslandia.common.base.BoolFormatException {
		return this.cfg.getRequiredBool(key);
	}

	@Override
	public java.sql.Date getRequiredDate(java.lang.String key) throws java.lang.NullPointerException, com.appslandia.common.base.DateFormatException {
		return this.cfg.getRequiredDate(key);
	}

	@Override
	public java.sql.Timestamp getRequiredDateTime(java.lang.String key) throws java.lang.NullPointerException, com.appslandia.common.base.DateFormatException {
		return this.cfg.getRequiredDateTime(key);
	}

	@Override
	public double getRequiredDouble(java.lang.String key) throws java.lang.NullPointerException, java.lang.NumberFormatException {
		return this.cfg.getRequiredDouble(key);
	}

	@Override
	public float getRequiredFloat(java.lang.String key) throws java.lang.NullPointerException, java.lang.NumberFormatException {
		return this.cfg.getRequiredFloat(key);
	}

	@Override
	public java.lang.String getRequiredFormatted(java.lang.String key) throws java.lang.NullPointerException {
		return this.cfg.getRequiredFormatted(key);
	}

	@Override
	public java.lang.String getRequiredFormatted(java.lang.String key, java.lang.Object... parameters) throws java.lang.NullPointerException {
		return this.cfg.getRequiredFormatted(key, parameters);
	}

	@Override
	public java.lang.String getRequiredFormatted(java.lang.String key, java.util.Map<java.lang.String, java.lang.Object> parameters) throws java.lang.NullPointerException {
		return this.cfg.getRequiredFormatted(key, parameters);
	}

	@Override
	public int getRequiredInt(java.lang.String key) throws java.lang.NullPointerException, java.lang.NumberFormatException {
		return this.cfg.getRequiredInt(key);
	}

	@Override
	public long getRequiredLong(java.lang.String key) throws java.lang.NullPointerException, java.lang.NumberFormatException {
		return this.cfg.getRequiredLong(key);
	}

	@Override
	public java.lang.String getRequiredString(java.lang.String key) throws java.lang.NullPointerException {
		return this.cfg.getRequiredString(key);
	}

	@Override
	public java.sql.Time getRequiredTime(java.lang.String key) throws java.lang.NullPointerException, com.appslandia.common.base.DateFormatException {
		return this.cfg.getRequiredTime(key);
	}

	@Override
	public java.lang.String getString(java.lang.String key) {
		return this.cfg.getString(key);
	}

	@Override
	public java.lang.String getString(java.lang.String key, java.lang.String defaultValue) {
		return this.cfg.getString(key, defaultValue);
	}

	@Override
	public java.lang.String[] getStringArray(java.lang.String key) {
		return this.cfg.getStringArray(key);
	}

	@Override
	public java.sql.Time getTime(java.lang.String key) {
		return this.cfg.getTime(key);
	}
}
