/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.validators;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ObjectUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ModelValidator<T> {
    private static Map<String, ModelValidator<?>> validators;

    public static Map<String, ModelValidator<?>> getValidators() {
        return AssertUtils.assertNotNull(validators, "validators is required.");
    }

    public static void setValidators(Map<String, ModelValidator<?>> validators) {
        AssertUtils.assertNull(ModelValidator.validators);
        ModelValidator.validators = Collections.unmodifiableMap(new HashMap(validators));
    }

    public static <T> ModelValidator<T> getValidator(String id) {
        AssertUtils.assertNotNull(id);
        ModelValidator<?> validator = ModelValidator.getValidators().get(id);
        if (validator == null) {
            throw new IllegalArgumentException("validator is not found (id=" + id + ")");
        }
        return (ModelValidator)ObjectUtils.cast(validator);
    }

    public abstract boolean validate(T var1);
}

