/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.base.CharArrayWriter;
import com.appslandia.common.utils.BitSetBuilder;
import com.appslandia.common.utils.CharsetUtils;
import java.util.BitSet;

public class URLEncoding {
    static final BitSet URL_PARAM_NOT_ENCODED = new BitSetBuilder(256).set("a-zA-Z0-9").set(45, 46, 95, 42).set(32).build();
    static final int caseDiff = 32;
    static final BitSet URL_PATH_NOT_ENCODED = new BitSetBuilder(256).set("a-zA-Z0-9").set(45, 46, 95, 126).set(58, 64).set(33, 36, 38, 39, 40, 41, 42, 43, 44, 59, 61).build();
    static final BitSet URL_PATH_NOT_ENCODED_XML_SAFE = new BitSetBuilder(URL_PATH_NOT_ENCODED).unset(38, 39).build();

    public static String encodeParam(String s) {
        return URLEncoding.encode(s, URL_PARAM_NOT_ENCODED);
    }

    public static String decodeParam(String s) {
        return URLEncoding.decode(s, EncodeType.URL_PARAM);
    }

    public static String encodePath(String s) {
        return URLEncoding.encode(s, URL_PATH_NOT_ENCODED);
    }

    public static String decodePath(String s) {
        return URLEncoding.decode(s, EncodeType.URL_PATH);
    }

    public static String encodePathXmlSafe(String s) {
        return URLEncoding.encode(s, URL_PATH_NOT_ENCODED_XML_SAFE);
    }

    static String encode(String s, BitSet notEncoding) {
        boolean needToChange = false;
        StringBuilder out = new StringBuilder((int)((float)s.length() * 1.25f));
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int i = 0;
        while (i < s.length()) {
            char c;
            int c2 = s.charAt(i);
            if (notEncoding.get(c2)) {
                if (c2 == 32) {
                    c2 = 43;
                    needToChange = true;
                }
                out.append((char)c2);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c2);
                if (c2 >= 55296 && c2 <= 56319 && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    charArrayWriter.write(d);
                    ++i;
                }
                if (++i >= s.length()) break;
                c = s.charAt(i);
                c2 = c;
            } while (!notEncoding.get(c));
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = str.getBytes(CharsetUtils.UTF_8);
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        charArrayWriter.close();
        return needToChange ? out.toString() : s;
    }

    static String decode(String s, EncodeType type) {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    if (type == EncodeType.URL_PARAM) {
                        sb.append(' ');
                        needToChange = true;
                    } else {
                        sb.append(c);
                    }
                    ++i;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, CharsetUtils.UTF_8));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    static enum EncodeType {
        URL_PARAM,
        URL_PATH;

    }
}

