/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final Pattern NON_DIGITS_PATTERN = Pattern.compile("[^\\d]+");

    public static String toLowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String toUpperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String firstLowerCase(String str) {
        if (str == null) {
            return null;
        }
        if (!str.isEmpty()) {
            return str.substring(0, 1).toLowerCase() + str.substring(1);
        }
        return str;
    }

    public static String firstUpperCase(String str) {
        if (str == null) {
            return null;
        }
        if (!str.isEmpty()) {
            return str.substring(0, 1).toUpperCase() + str.substring(1);
        }
        return str;
    }

    public static String trimToNull(String str) {
        return StringUtils.trimToDefault(str, null);
    }

    public static String trimToEmpty(String str) {
        return str != null ? str.trim() : EMPTY_STRING;
    }

    public static String trimToDefault(String str, String defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return !(str = str.trim()).isEmpty() ? str : defaultValue;
    }

    public static String nullOrLowerCase(String str) {
        if (str == null) {
            return null;
        }
        return !str.isEmpty() ? str.toLowerCase() : null;
    }

    public static String nullOrUpperCase(String str) {
        if (str == null) {
            return null;
        }
        return !str.isEmpty() ? str.toUpperCase() : null;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean startsWithIgnoreCase(String str, String substr) {
        AssertUtils.assertNotNull(str);
        AssertUtils.assertNotNull(substr);
        if (substr.isEmpty()) {
            return true;
        }
        return str.regionMatches(true, 0, substr, 0, substr.length());
    }

    public static boolean endsWithIgnoreCase(String str, String substr) {
        AssertUtils.assertNotNull(str);
        AssertUtils.assertNotNull(substr);
        if (substr.isEmpty()) {
            return true;
        }
        return str.regionMatches(true, str.length() - substr.length(), substr, 0, substr.length());
    }

    public static boolean containsIgnoreCase(String str, String substr) {
        AssertUtils.assertNotNull(str);
        AssertUtils.assertNotNull(substr);
        if (substr.isEmpty()) {
            return true;
        }
        int maxOffset = str.length() - substr.length();
        for (int offset = 0; offset <= maxOffset; ++offset) {
            if (!str.regionMatches(true, offset, substr, 0, substr.length())) continue;
            return true;
        }
        return false;
    }

    public static String digitOnly(String str) {
        if (str == null) {
            return null;
        }
        return !(str = NON_DIGITS_PATTERN.matcher(str).replaceAll(EMPTY_STRING)).isEmpty() ? str : null;
    }
}

