/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ReflectionException;
import com.appslandia.common.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class ReflectionUtils {
    public static final Object[] EMPTY_OBJECTS = new Object[0];
    public static final Class<?>[] EMPTY_CLASSES = new Class[0];
    public static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];

    public static Field findField(Class<?> clazz, final String property) throws ReflectionException {
        return ReflectionUtils.traverse(clazz, new FieldHandler(){

            @Override
            public boolean matches(Field f) {
                if (f.getName().equals(property)) {
                    return true;
                }
                return f.getType() == Boolean.TYPE && f.getName().equals("is" + StringUtils.firstUpperCase(property));
            }

            @Override
            public boolean handle(Field field) throws ReflectionException {
                return false;
            }
        });
    }

    public static Method findMethod(Class<?> clazz, final String methodName) throws ReflectionException {
        return ReflectionUtils.traverse(clazz, new MethodHandler(){

            @Override
            public boolean matches(Method m) {
                return m.getName().equals(methodName);
            }

            @Override
            public boolean handle(Method m) throws ReflectionException {
                return false;
            }
        });
    }

    public static Field traverse(Class<?> clazz, FieldHandler handler) throws ReflectionException {
        Field matched = null;
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!handler.matches(field)) continue;
                matched = field;
                if (handler.handle(field)) continue;
                return matched;
            }
            clazz = clazz.getSuperclass();
        }
        return matched;
    }

    public static Method traverse(Class<?> clazz, MethodHandler handler) throws ReflectionException {
        Method matched = null;
        while (clazz != null) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!handler.matches(m)) continue;
                matched = m;
                if (handler.handle(m)) continue;
                return matched;
            }
            clazz = clazz.getSuperclass();
        }
        return matched;
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationClass) {
        while (clazz != null) {
            T t = clazz.getAnnotation(annotationClass);
            if (t != null) {
                return t;
            }
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                t = interfaceClass.getAnnotation(annotationClass);
                if (t == null) continue;
                return t;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Object invoke(Method m, Object obj, Object ... args) throws ReflectionException {
        try {
            return m.invoke(obj, args);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static void set(Field m, Object obj, Object value) throws ReflectionException {
        try {
            m.set(obj, value);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Object get(Field m, Object obj) throws ReflectionException {
        try {
            return m.get(obj);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static <T> T newInstance(Class<T> clazz) throws ReflectionException {
        try {
            return clazz.getDeclaredConstructor(EMPTY_CLASSES).newInstance(EMPTY_OBJECTS);
        }
        catch (NoSuchMethodException ex) {
            throw new ReflectionException(ex);
        }
        catch (SecurityException ex) {
            throw new ReflectionException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ex);
        }
        catch (InstantiationException ex) {
            throw new ReflectionException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static <T> Class<? extends T> loadClass(String className, ClassLoader loader) throws ReflectionException {
        ClassLoader cl = loader != null ? loader : ReflectionUtils.getDefaultClassLoader();
        try {
            return (Class)ObjectUtils.cast(cl.loadClass(className));
        }
        catch (ClassNotFoundException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ReflectionUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static boolean isImplementOf(Method implMth, Method interfaceMth) {
        return interfaceMth.getDeclaringClass().isAssignableFrom(implMth.getDeclaringClass()) && interfaceMth.getName().equals(implMth.getName()) && Arrays.equals(interfaceMth.getParameterTypes(), implMth.getParameterTypes());
    }

    public static Method getRequiredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new ReflectionException(ex);
        }
        catch (SecurityException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static boolean isPublicConst(int modifier) {
        return Modifier.isPublic(modifier) && Modifier.isStatic(modifier) && Modifier.isFinal(modifier);
    }

    public static interface MethodHandler {
        public boolean matches(Method var1);

        public boolean handle(Method var1) throws ReflectionException;
    }

    public static interface FieldHandler {
        public boolean matches(Field var1);

        public boolean handle(Field var1) throws ReflectionException;
    }
}

