/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.PatternUtils;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class NormalizeUtils {
    private static DecomposedCharacterConverter decomposedCharacterConverter;
    private static final Pattern STRIP_ACCENTS_PATTERN;
    private static final Pattern[] WHITESPACE_PUNCT_DOUBLE_HYPHEN_PATTERNS;
    private static final Pattern[] DOUBLE_WHITESPACES_PATTERNS;

    public static void setDecomposedCharacterConverter(DecomposedCharacterConverter obj) {
        AssertUtils.assertNull(decomposedCharacterConverter);
        decomposedCharacterConverter = obj;
    }

    public static String unaccent(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder decomposed = new StringBuilder(Normalizer.normalize(text, Normalizer.Form.NFD));
        if (decomposedCharacterConverter != null) {
            for (int i = 0; i < decomposed.length(); ++i) {
                char converted = decomposedCharacterConverter.convert(decomposed.charAt(i));
                if (converted == decomposed.charAt(i)) continue;
                decomposed.deleteCharAt(i);
                decomposed.insert(i, converted);
            }
        }
        return STRIP_ACCENTS_PATTERN.matcher(decomposed).replaceAll("");
    }

    public static String toLabel(String text) {
        return NormalizeUtils.normalize(text, WHITESPACE_PUNCT_DOUBLE_HYPHEN_PATTERNS, '-');
    }

    public static String toText(String text) {
        return NormalizeUtils.normalize(text, DOUBLE_WHITESPACES_PATTERNS, ' ');
    }

    public static String normalize(String text, Pattern[] replacePatterns, char bySep) {
        if (text == null) {
            return null;
        }
        String replacement = new String(new char[]{bySep});
        for (Pattern p : replacePatterns) {
            text = p.matcher(text).replaceAll(replacement);
        }
        return !(text = NormalizeUtils.trim(text, bySep)).isEmpty() ? text : null;
    }

    private static String trim(String name, char charToTrim) {
        int start = -1;
        while (++start < name.length() && name.charAt(start) == charToTrim) {
        }
        int end = name.length();
        while (--end >= 0 && name.charAt(end) == charToTrim) {
        }
        if (start >= end) {
            return "";
        }
        return name.substring(start, end + 1);
    }

    static {
        STRIP_ACCENTS_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        WHITESPACE_PUNCT_DOUBLE_HYPHEN_PATTERNS = PatternUtils.compile("\\s+|\\p{Punct}+", "-{2,}");
        DOUBLE_WHITESPACES_PATTERNS = PatternUtils.compile("\\s{2,}");
    }

    public static interface DecomposedCharacterConverter {
        public char convert(char var1);
    }
}

