/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.utils;

import com.appslandia.common.utils.CharUtils;
import java.util.BitSet;

public class BitSetBuilder {
    final BitSet bits;

    public BitSetBuilder(BitSet willClone) {
        this.bits = (BitSet)willClone.clone();
    }

    public BitSetBuilder(int initialCapacity) {
        this.bits = new BitSet(initialCapacity);
    }

    public BitSet build() {
        return this.bits;
    }

    public BitSetBuilder set(int ... bitIndexes) {
        for (int index : bitIndexes) {
            this.bits.set(index);
        }
        return this;
    }

    public BitSetBuilder set(String indexRanges) {
        for (char chr : CharUtils.toCharRanges(indexRanges)) {
            this.bits.set(chr);
        }
        return this;
    }

    public BitSetBuilder unset(int ... bitIndexes) {
        for (int index : bitIndexes) {
            this.bits.clear(index);
        }
        return this;
    }

    public BitSetBuilder unset(String indexRanges) {
        for (char chr : CharUtils.toCharRanges(indexRanges)) {
            this.bits.clear(chr);
        }
        return this;
    }
}

