/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.threading;

public class ThreadLocalStorage<T> {
    final ThreadLocal<T> holder;

    public ThreadLocalStorage() {
        this(false);
    }

    public ThreadLocalStorage(ThreadLocal<T> holder) {
        this.holder = holder;
    }

    public ThreadLocalStorage(boolean inheritable) {
        this.holder = !inheritable ? new ThreadLocal() : new InheritableThreadLocal();
    }

    public T get() {
        return this.holder.get();
    }

    public T getRequiredValue() {
        T t = this.holder.get();
        if (t == null) {
            throw new IllegalStateException("No current thread's value.");
        }
        return t;
    }

    public void set(T value) {
        if (value == null) {
            this.holder.remove();
        } else {
            this.holder.set(value);
        }
    }
}

