/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.objects;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.objects.ObjectProducer;
import com.appslandia.common.objects.ObjectScope;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ReflectionUtils;
import com.appslandia.common.utils.ValueUtils;
import java.lang.annotation.Annotation;

public class ObjectDefinition
extends InitializeObject {
    private Class<?> type;
    private Annotation[] qualifiers;
    private ObjectScope scope;
    private Class<?> implClass;
    private ObjectProducer<?> producer;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.type);
        AssertUtils.assertNotNull(this.scope);
        AssertUtils.assertTrue(this.implClass != null || this.producer != null);
        this.qualifiers = ValueUtils.getValue(this.qualifiers, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    public Class<?> getType() {
        this.initialize();
        return this.type;
    }

    public ObjectDefinition setType(Class<?> type) {
        this.assertNotInitialized();
        this.type = type;
        return this;
    }

    public Annotation[] getQualifiers() {
        this.initialize();
        return this.qualifiers;
    }

    public ObjectDefinition setQualifiers(Annotation ... qualifiers) {
        this.assertNotInitialized();
        this.qualifiers = qualifiers;
        return this;
    }

    public ObjectScope getScope() {
        this.initialize();
        return this.scope;
    }

    public ObjectDefinition setScope(ObjectScope scope) {
        this.assertNotInitialized();
        this.scope = scope;
        return this;
    }

    public Class<?> getImplClass() {
        this.initialize();
        return this.implClass;
    }

    public ObjectDefinition setImplClass(Class<?> implClass) {
        this.assertNotInitialized();
        this.implClass = implClass;
        return this;
    }

    public ObjectProducer<?> getProducer() {
        this.initialize();
        return this.producer;
    }

    public ObjectDefinition setProducer(ObjectProducer<?> producer) {
        this.assertNotInitialized();
        this.producer = producer;
        return this;
    }
}

