/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jose;

import com.appslandia.common.base.MapWrapper;
import com.appslandia.common.jose.JoseUtils;
import com.appslandia.common.utils.CollectionUtils;
import com.appslandia.common.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JwtPayload
extends MapWrapper<String, Object> {
    private static final long serialVersionUID = 1L;
    public static final String ISS = "iss";
    public static final String SUB = "sub";
    public static final String AUD = "aud";
    public static final String EXP = "exp";
    public static final String NBF = "nbf";
    public static final String IAT = "iat";
    public static final String JTI = "jti";

    public JwtPayload() {
        super(new LinkedHashMap());
    }

    protected JwtPayload(Map<String, Object> map) {
        super(map);
    }

    public String getIssuer() {
        return (String)this.map.get(ISS);
    }

    public JwtPayload setIssuer(String value) {
        this.map.put(ISS, value);
        return this;
    }

    public String getSubject() {
        return (String)this.map.get(SUB);
    }

    public JwtPayload setSubject(String value) {
        this.map.put(SUB, value);
        return this;
    }

    public List<String> getAudiences() {
        Object value = this.map.get(AUD);
        if (value == null) {
            return null;
        }
        if (value.getClass() == String.class) {
            return CollectionUtils.toList(new ArrayList(1), new String[]{(String)value});
        }
        return (List)ObjectUtils.cast(value);
    }

    public JwtPayload setAudiences(String ... values) {
        if (values.length == 0) {
            return this;
        }
        this.map.put(AUD, values.length == 1 ? values[0] : CollectionUtils.toList(values));
        return this;
    }

    public Date getExpiresAt() {
        return this.getNumericDate(EXP);
    }

    public JwtPayload setExpiresAt(Date value) {
        return this.putNumericDate(EXP, value);
    }

    public Date getNotBefore() {
        return this.getNumericDate(NBF);
    }

    public JwtPayload setNotBefore(Date value) {
        return this.putNumericDate(NBF, value);
    }

    public Date getIssuedAt() {
        return this.getNumericDate(IAT);
    }

    public JwtPayload setIssuedAt(Date value) {
        return this.putNumericDate(IAT, value);
    }

    public String getJwtId() {
        return (String)this.map.get(JTI);
    }

    public JwtPayload setJwtId(String value) {
        this.map.put(JTI, value);
        return this;
    }

    @Override
    public JwtPayload put(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public JwtPayload putArray(String key, Object ... values) {
        this.map.put(key, values);
        return this;
    }

    public Long getLong(String key) {
        Object obj = this.map.get(key);
        return obj != null ? JoseUtils.toLongValue(obj) : null;
    }

    public Long getRequiredLong(String key) throws NullPointerException {
        Object obj = this.map.get(key);
        if (obj == null) {
            throw new NullPointerException("key=" + key);
        }
        return JoseUtils.toLongValue(obj);
    }

    public Double getDouble(String key) {
        Object obj = this.map.get(key);
        return obj != null ? JoseUtils.toDoubleValue(obj) : null;
    }

    public Double getRequiredDouble(String key) throws NullPointerException {
        Object obj = this.map.get(key);
        if (obj == null) {
            throw new NullPointerException("key=" + key);
        }
        return JoseUtils.toDoubleValue(obj);
    }

    public <T> T getObject(String key) {
        Object obj = this.map.get(key);
        return ObjectUtils.cast(obj);
    }

    public <T> T getRequiredObject(String key) throws NullPointerException {
        Object obj = this.map.get(key);
        if (obj == null) {
            throw new NullPointerException("key=" + key);
        }
        return ObjectUtils.cast(obj);
    }

    public Date getNumericDate(String key) {
        Long nd = (Long)this.map.get(key);
        return nd != null ? JoseUtils.toDate(nd) : null;
    }

    public Date getRequiredNumericDate(String key) throws NullPointerException {
        Long nd = (Long)this.map.get(key);
        if (nd == null) {
            throw new NullPointerException("key=" + key);
        }
        return JoseUtils.toDate(nd);
    }

    public JwtPayload putNumericDate(String key, Date value) {
        if (value == null) {
            return this;
        }
        this.map.put(key, JoseUtils.toNumericDate(value));
        return this;
    }
}

