/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jose;

import com.appslandia.common.base.MapWrapper;
import com.appslandia.common.jose.JoseUtils;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class JoseHeader
extends MapWrapper<String, Object> {
    private static final long serialVersionUID = 1L;
    public static final String TYP = "typ";
    public static final String ALG = "alg";
    public static final String KID = "kid";

    public JoseHeader() {
        super(new LinkedHashMap());
    }

    protected JoseHeader(Map<String, Object> map) {
        super(map);
    }

    public String getType() {
        return (String)this.map.get(TYP);
    }

    public JoseHeader setType(String value) {
        this.map.put(TYP, value);
        return this;
    }

    public String getAlgorithm() {
        return (String)this.map.get(ALG);
    }

    public JoseHeader setAlgorithm(String value) {
        this.map.put(ALG, value);
        return this;
    }

    public String getKid() {
        return (String)this.map.get(KID);
    }

    public JoseHeader setKid(String value) {
        this.map.put(KID, value);
        return this;
    }

    @Override
    public JoseHeader put(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public Date getNumericDate(String key) {
        Long nd = (Long)this.map.get(key);
        return JoseUtils.toDate(nd);
    }

    public JoseHeader putNumericDate(String key, Date value) {
        if (value == null) {
            return this;
        }
        this.map.put(key, JoseUtils.toNumericDate(value));
        return this;
    }
}

