/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jdbc;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CollectionUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Sql
extends InitializeObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_ARRAY_MAX_LENGTH = 32;
    private String sql;
    private Map<String, Integer> arrayLens;
    private String translatedSql;
    private Map<String, int[]> indexesMap;

    public Sql() {
    }

    public Sql(String sql) {
        this.sql = sql;
    }

    public Sql arrayLen(String parameterName, int maxLength) {
        this.assertNotInitialized();
        AssertUtils.assertTrue(maxLength > 0, "maxLength is required.");
        if (this.arrayLens == null) {
            this.arrayLens = new HashMap<String, Integer>();
        }
        this.arrayLens.put(parameterName, maxLength);
        return this;
    }

    public Sql sql(String sql) {
        this.assertNotInitialized();
        this.sql = sql;
        return this;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.sql, "sql is required.");
        this.translateSql();
    }

    private void translateSql() {
        int j;
        StringBuilder sb = new StringBuilder(this.sql);
        LinkedHashMap<String, int[]> indexesMap = new LinkedHashMap<String, int[]>();
        int i = 0;
        int index = 0;
        while (true) {
            int subIdx;
            Integer arrayLen;
            int k;
            for (j = i; j < sb.length() - 1 && sb.charAt(j) != '@'; ++j) {
            }
            if (j >= sb.length() - 1 || !Character.isLetter(sb.charAt(j + 1))) break;
            for (k = j + 1; k < sb.length() && (Character.isLetterOrDigit(sb.charAt(k)) || sb.charAt(k) == '_'); ++k) {
            }
            String paramName = sb.substring(j + 1, k);
            sb.delete(j, k);
            boolean isArrayParam = Sql.isArrayContext(sb, j);
            Integer n = arrayLen = this.arrayLens == null ? null : this.arrayLens.get(paramName);
            if (arrayLen != null) {
                if (!isArrayParam) {
                    throw new IllegalArgumentException("Array parameter is not found (name=" + paramName + ")");
                }
            } else if (isArrayParam) {
                arrayLen = 32;
                if (this.arrayLens == null) {
                    this.arrayLens = new HashMap<String, Integer>();
                }
                this.arrayLens.put(paramName, arrayLen);
            }
            int len = isArrayParam ? arrayLen : 1;
            for (subIdx = 0; subIdx < len; ++subIdx) {
                if (subIdx == 0) {
                    sb.insert(j, '?');
                    continue;
                }
                sb.insert(j, "?, ");
            }
            for (subIdx = 0; subIdx < len; ++subIdx) {
                String name = isArrayParam ? Sql.toParamName(paramName, subIdx) : paramName;
                int[] indexes = (int[])indexesMap.get(name);
                if (indexes == null) {
                    indexes = new int[]{++index};
                } else {
                    indexes = Arrays.copyOf(indexes, indexes.length + 1);
                    indexes[indexes.length - 1] = ++index;
                }
                indexesMap.put(name, indexes);
            }
            i = j + len;
        }
        if (j < sb.length() - 1) {
            throw new IllegalArgumentException("sql is invalid.");
        }
        this.translatedSql = sb.toString();
        this.indexesMap = CollectionUtils.unmodifiable(indexesMap);
    }

    public String getSql() {
        this.initialize();
        return this.sql;
    }

    public String getTranslatedSql() {
        this.initialize();
        return this.translatedSql;
    }

    public int[] getIndexes(String parameterName) {
        this.initialize();
        int[] indexes = this.indexesMap.get(parameterName);
        if (indexes == null) {
            throw new IllegalArgumentException("Parameter is required (name=" + parameterName + ")");
        }
        return indexes;
    }

    public int getArrayLen(String parameterName) {
        Integer len;
        this.initialize();
        Integer n = len = this.arrayLens != null ? this.arrayLens.get(parameterName) : null;
        if (len == null) {
            throw new IllegalArgumentException("Array parameter is not found (name=" + parameterName + ")");
        }
        return len;
    }

    public static String toParamName(String parameterName, int subIdx) {
        return parameterName + "__" + subIdx;
    }

    private static boolean isArrayContext(StringBuilder sb, int paramIndex) {
        int k;
        if (sb.length() < 6) {
            return false;
        }
        for (k = paramIndex; k < sb.length() && Character.isWhitespace(sb.charAt(k)); ++k) {
        }
        if (k >= sb.length() || sb.charAt(k) != ')') {
            return false;
        }
        for (k = paramIndex - 1; k >= 0 && Character.isWhitespace(sb.charAt(k)); --k) {
        }
        if (k < 0 || sb.charAt(k) != '(') {
            return false;
        }
        --k;
        while (k >= 0 && Character.isWhitespace(sb.charAt(k))) {
            --k;
        }
        return k > 2 && Character.toUpperCase(sb.charAt(k)) == 'N' && Character.toUpperCase(sb.charAt(k - 1)) == 'I' && Character.isWhitespace(sb.charAt(k - 2));
    }
}

