/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.NumberFormatter;
import java.text.NumberFormat;

public class IntegerFormatter
extends NumberFormatter {
    public static final String ERROR_MSG_KEY = IntegerFormatter.class.getName() + ".message";

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgumentType() {
        return Integer.class;
    }

    @Override
    protected NumberFormat getNumberFormat(FormatProvider formatProvider) {
        return formatProvider.getIntegerFormat();
    }

    @Override
    public Integer parse(String str, FormatProvider formatProvider) throws FormatterException {
        Number number = this.parseNumber(str, formatProvider);
        if (number == null) {
            return null;
        }
        long value = number.longValue();
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw this.parsedOverflowException(str);
        }
        return number.intValue();
    }
}

