/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Provider;
import com.appslandia.common.formatters.BigDecimalFormatter;
import com.appslandia.common.formatters.BigIntegerFormatter;
import com.appslandia.common.formatters.BooleanFormatter;
import com.appslandia.common.formatters.ByteFormatter;
import com.appslandia.common.formatters.DoubleFormatter;
import com.appslandia.common.formatters.FloatFormatter;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.IntegerFormatter;
import com.appslandia.common.formatters.LongFormatter;
import com.appslandia.common.formatters.LowerCaseFormatter;
import com.appslandia.common.formatters.ShortFormatter;
import com.appslandia.common.formatters.SqlDateFormatter;
import com.appslandia.common.formatters.SqlDateTime24HFormatter;
import com.appslandia.common.formatters.SqlDateTimeFormatter;
import com.appslandia.common.formatters.SqlTime24HFormatter;
import com.appslandia.common.formatters.SqlTimeFormatter;
import com.appslandia.common.formatters.StringFormatter;
import com.appslandia.common.formatters.UpperCaseFormatter;
import com.appslandia.common.models.Format;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.TypeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FormatterProvider
extends InitializeObject {
    private Map<String, Formatter> formatterMap = new HashMap<String, Formatter>();
    private static volatile FormatterProvider __default;
    private static final Object MUTEX;
    private static Provider<FormatterProvider> __provider;

    @Override
    protected void init() throws Exception {
        this.addDefault(Formatter.BYTE, new ByteFormatter());
        this.addDefault(Formatter.SHORT, new ShortFormatter());
        this.addDefault(Formatter.INTEGER, new IntegerFormatter());
        this.addDefault(Formatter.LONG, new LongFormatter());
        this.addDefault(Formatter.BIGINTEGER, new BigIntegerFormatter());
        this.addDefault(Formatter.FLOAT, new FloatFormatter());
        this.addDefault(Formatter.DOUBLE, new DoubleFormatter());
        this.addDefault(Formatter.BIGDECIMAL, new BigDecimalFormatter());
        this.addDefault(Formatter.SQL_DATE, new SqlDateFormatter());
        this.addDefault(Formatter.SQL_TIME, new SqlTimeFormatter());
        this.addDefault(Formatter.SQL_DATETIME, new SqlDateTimeFormatter());
        this.addDefault("Time24H", new SqlTime24HFormatter());
        this.addDefault("DateTime24H", new SqlDateTime24HFormatter());
        this.addDefault(Formatter.BOOLEAN, new BooleanFormatter());
        this.addDefault(Formatter.STRING, new StringFormatter());
        this.addDefault("UpperCase", new UpperCaseFormatter());
        this.addDefault("LowerCase", new LowerCaseFormatter());
        this.formatterMap = Collections.unmodifiableMap(this.formatterMap);
    }

    protected void addDefault(String id, Formatter formatter) {
        if (!this.formatterMap.containsKey(id)) {
            this.formatterMap.put(id, formatter);
        }
    }

    public void addFormatter(String id, Formatter formatter) {
        this.assertNotInitialized();
        this.formatterMap.put(id, formatter);
    }

    public Formatter findFormatter(Format formatter, Class<?> targetType) {
        this.initialize();
        if (formatter != null) {
            return this.getFormatter(formatter.value());
        }
        return this.formatterMap.get(TypeUtils.wrap(targetType).getSimpleName());
    }

    public Formatter getFormatter(Class<?> targetType) throws IllegalArgumentException {
        this.initialize();
        Formatter formatter = this.formatterMap.get(TypeUtils.wrap(targetType).getSimpleName());
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter is required (targetType=" + targetType + ")");
        }
        return formatter;
    }

    public Formatter getFormatter(String id) throws IllegalArgumentException {
        this.initialize();
        Formatter formatter = this.formatterMap.get(id);
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter is not found (id=" + id + ")");
        }
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormatterProvider getDefault() {
        FormatterProvider obj = __default;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __default;
                if (obj == null) {
                    __default = obj = FormatterProvider.initFormatterProvider();
                }
            }
        }
        return obj;
    }

    public static void setDefault(FormatterProvider obj) {
        AssertUtils.assertNull(__default);
        __default = obj;
    }

    public static void setProvider(Provider<FormatterProvider> provider) {
        AssertUtils.assertNull(__default);
        __provider = provider;
    }

    private static FormatterProvider initFormatterProvider() {
        if (__provider != null) {
            return __provider.get();
        }
        return new FormatterProvider();
    }

    static {
        MUTEX = new Object();
    }
}

