/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.crypto;

import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.Encryptor;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.MathUtils;

public class EncryptorSigner
extends InitializeObject
implements Encryptor {
    private Digester signer;
    private Encryptor encryptor;

    public EncryptorSigner() {
    }

    public EncryptorSigner(Digester signer) {
        this.signer = signer;
    }

    public EncryptorSigner(Digester signer, Encryptor encryptor) {
        this.signer = signer;
        this.encryptor = encryptor;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.signer, "signer is required.");
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.encryptor != null) {
            this.encryptor.destroy();
        }
        if (this.signer != null) {
            this.signer.destroy();
        }
        super.destroy();
    }

    @Override
    public byte[] encrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        byte[] encrypted = this.encryptor != null ? this.encryptor.encrypt(message) : message;
        byte[] digested = this.signer.digest(encrypted);
        if (this.signer.getDigestLength() > 0) {
            return ArrayUtils.append(digested, encrypted);
        }
        byte[] len = MathUtils.toByteArray(digested.length);
        return ArrayUtils.append(len, digested, encrypted);
    }

    @Override
    public byte[] decrypt(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        byte[] digested = null;
        byte[] parsedMsg = null;
        int digestLength = this.signer.getDigestLength();
        if (digestLength > 0) {
            digested = new byte[digestLength];
            AssertUtils.assertTrue(message.length > digestLength, "message is invalid.");
            parsedMsg = new byte[message.length - digestLength];
            ArrayUtils.copy(message, digested, parsedMsg);
        } else {
            byte[] len = new byte[4];
            AssertUtils.assertTrue(message.length > 4, "message is invalid.");
            ArrayUtils.copy(message, len);
            digestLength = MathUtils.toInt(len);
            digested = new byte[digestLength];
            parsedMsg = new byte[message.length - digestLength - 4];
            System.arraycopy(message, 4, digested, 0, digestLength);
            System.arraycopy(message, 4 + digestLength, parsedMsg, 0, parsedMsg.length);
        }
        if (!this.signer.verify(parsedMsg, digested)) {
            throw new CryptoException("message was tampered.");
        }
        return this.encryptor != null ? this.encryptor.decrypt(parsedMsg) : parsedMsg;
    }

    public EncryptorSigner setSigner(Digester signer) {
        this.assertNotInitialized();
        this.signer = signer;
        return this;
    }

    public EncryptorSigner setEncryptor(Encryptor encryptor) {
        this.assertNotInitialized();
        this.encryptor = encryptor;
        return this;
    }

    @Override
    public EncryptorSigner copy() {
        EncryptorSigner impl = new EncryptorSigner();
        if (this.encryptor != null) {
            impl.encryptor = this.encryptor.copy();
        }
        if (this.signer != null) {
            impl.signer = this.signer.copy();
        }
        return impl;
    }
}

